/*
 * Decompiled with CFR 0.152.
 */
package org.acra.sender;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.config.RetryPolicy;
import org.acra.data.CrashReportData;
import org.acra.file.CrashReportPersister;
import org.acra.log.ACRALog;
import org.acra.sender.ReportDistributor;
import org.acra.sender.ReportSender;
import org.acra.sender.ReportSenderException;
import org.acra.util.IOUtils;
import org.acra.util.InstanceCreator;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/acra/sender/ReportDistributor;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportSenders", "", "Lorg/acra/sender/ReportSender;", "extras", "Landroid/os/Bundle;", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;Ljava/util/List;Landroid/os/Bundle;)V", "isDebuggable", "", "()Z", "distribute", "reportFile", "Ljava/io/File;", "sendCrashReport", "", "errorContent", "Lorg/acra/data/CrashReportData;", "acra-core_release"})
public final class ReportDistributor {
    @NotNull
    private final Context context;
    @NotNull
    private final CoreConfiguration config;
    @NotNull
    private final List<ReportSender> reportSenders;
    @NotNull
    private final Bundle extras;

    public ReportDistributor(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull List<? extends ReportSender> reportSenders, @NotNull Bundle extras) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(reportSenders, (String)"reportSenders");
        Intrinsics.checkNotNullParameter((Object)extras, (String)"extras");
        this.context = context;
        this.config = config;
        this.reportSenders = reportSenders;
        this.extras = extras;
    }

    public final boolean distribute(@NotNull File reportFile) {
        boolean $i$f$error;
        Intrinsics.checkNotNullParameter((Object)reportFile, (String)"reportFile");
        boolean $i$f$info = false;
        String string = ACRA.LOG_TAG;
        ACRALog aCRALog = ACRA.log;
        boolean bl = false;
        String string2 = Intrinsics.stringPlus((String)"Sending report ", (Object)reportFile);
        aCRALog.i(string, string2);
        try {
            CrashReportPersister persister = new CrashReportPersister();
            CrashReportData previousCrashReport = persister.load(reportFile);
            this.sendCrashReport(previousCrashReport);
            IOUtils.deleteFile(reportFile);
            return true;
        }
        catch (RuntimeException e) {
            $i$f$error = false;
            string = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl2 = false;
            string2 = Intrinsics.stringPlus((String)"Failed to send crash reports for ", (Object)reportFile);
            aCRALog.e(string, string2, e);
            IOUtils.deleteFile(reportFile);
        }
        catch (IOException e) {
            $i$f$error = false;
            string = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl3 = false;
            string2 = Intrinsics.stringPlus((String)"Failed to send crash reports for ", (Object)reportFile);
            aCRALog.e(string, string2, e);
            IOUtils.deleteFile(reportFile);
        }
        catch (JSONException e) {
            $i$f$error = false;
            string = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl4 = false;
            string2 = Intrinsics.stringPlus((String)"Failed to send crash reports for ", (Object)reportFile);
            aCRALog.e(string, string2, e);
            IOUtils.deleteFile(reportFile);
        }
        catch (ReportSenderException e) {
            $i$f$error = false;
            string = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl5 = false;
            string2 = Intrinsics.stringPlus((String)"Failed to send crash reports for ", (Object)reportFile);
            aCRALog.e(string, string2, e);
        }
        return false;
    }

    private final void sendCrashReport(CrashReportData errorContent) throws ReportSenderException {
        if (!this.isDebuggable() || this.config.getSendReportsInDevMode()) {
            Object object;
            ACRALog aCRALog;
            String string;
            List failedSenders = new LinkedList();
            for (ReportSender sender : this.reportSenders) {
                try {
                    boolean $i$f$debug = false;
                    if (ACRA.DEV_LOGGING) {
                        string = ACRA.LOG_TAG;
                        aCRALog = ACRA.log;
                        boolean bl = false;
                        object = Intrinsics.stringPlus((String)"Sending report using ", (Object)sender.getClass().getName());
                        aCRALog.d(string, (String)object);
                    }
                    sender.send(this.context, errorContent, this.extras);
                    $i$f$debug = false;
                    if (!ACRA.DEV_LOGGING) continue;
                    string = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    object = Intrinsics.stringPlus((String)"Sent report using ", (Object)sender.getClass().getName());
                    aCRALog.d(string, (String)object);
                }
                catch (ReportSenderException e) {
                    failedSenders.add(new RetryPolicy.FailedSender(sender, e));
                }
            }
            if (failedSenders.isEmpty()) {
                boolean $i$f$debug = false;
                if (ACRA.DEV_LOGGING) {
                    string = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    object = "Report was sent by all senders";
                    aCRALog.d(string, (String)object);
                }
            } else {
                if (InstanceCreator.create(this.config.getRetryPolicyClass(), sendCrashReport.4.INSTANCE).shouldRetrySend(this.reportSenders, failedSenders)) {
                    throw new ReportSenderException("Policy marked this task as incomplete. ACRA will try to send this report again.", ((RetryPolicy.FailedSender)failedSenders.get(0)).getException());
                }
                boolean $i$f$warn = false;
                string = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                StringBuilder builder = new StringBuilder("ReportSenders of classes [");
                for (RetryPolicy.FailedSender failedSender : failedSenders) {
                    builder.append(failedSender.getSender().getClass().getName());
                    builder.append(", ");
                }
                builder.append("] failed, but Policy marked this task as complete. ACRA will not send this report again.");
                String string2 = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
                object = string2;
                aCRALog.w(string, (String)object);
            }
        }
    }

    private final boolean isDebuggable() {
        boolean bl;
        try {
            bl = (this.context.getPackageManager().getApplicationInfo((String)this.context.getPackageName(), (int)0).flags & 2) > 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            bl = false;
        }
        return bl;
    }
}

