/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.RequiresPermission;
import com.google.auto.service.AutoService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.util.PackageManagerWrapper;
import org.acra.util.SystemServices;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/acra/collector/DeviceIdCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "()V", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "shouldCollect", "", "acra-core_release"})
@AutoService(value={Collector.class})
public class DeviceIdCollector
extends BaseReportFieldCollector {
    public DeviceIdCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.DEVICE_ID};
        super(reportFieldArray);
    }

    @Override
    public boolean shouldCollect(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportField collect, @NotNull ReportBuilder reportBuilder) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)collect, (String)"collect");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        return super.shouldCollect(context, config, collect, reportBuilder) && new SharedPreferencesFactory(context, config).create().getBoolean("acra.deviceid.enable", true) && new PackageManagerWrapper(context).hasPermission("android.permission.READ_PHONE_STATE");
    }

    @Override
    @SuppressLint(value={"MissingPermission", "HardwareIds"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws Exception {
        Intrinsics.checkNotNullParameter((Object)reportField, (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        target.put(ReportField.DEVICE_ID, SystemServices.getTelephonyManager(context).getDeviceId());
    }
}

