/*
 * Decompiled with CFR 0.152.
 */
package org.acra.attachment;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.acra.ACRA;
import org.acra.file.Directory;
import org.acra.log.ACRALog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0004H\u0016JK\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u001cJ9\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\u001eR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/acra/attachment/AcraContentProvider;", "Landroid/content/ContentProvider;", "()V", "authority", "", "delete", "", "uri", "Landroid/net/Uri;", "selection", "selectionArgs", "", "(Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)I", "getFileForUri", "Ljava/io/File;", "getType", "insert", "values", "Landroid/content/ContentValues;", "onCreate", "", "openFile", "Landroid/os/ParcelFileDescriptor;", "mode", "query", "Landroid/database/Cursor;", "projection", "sortOrder", "(Landroid/net/Uri;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;", "update", "(Landroid/net/Uri;Landroid/content/ContentValues;Ljava/lang/String;[Ljava/lang/String;)I", "Companion", "acra-core_release"})
public final class AcraContentProvider
extends ContentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String authority;
    @NotNull
    private static final String[] COLUMNS;
    @NotNull
    private static final String MIME_TYPE_OCTET_STREAM = "application/octet-stream";

    public boolean onCreate() {
        Context context = this.getContext();
        Intrinsics.checkNotNull((Object)context);
        Context context2 = context;
        this.authority = AcraContentProvider.Companion.getAuthority(context2);
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = Intrinsics.stringPlus((String)"Registered content provider for authority ", (Object)this.authority);
            aCRALog.d(string, string2);
        }
        return true;
    }

    @Nullable
    public Cursor query(@NotNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Object[] proj = projection;
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = Intrinsics.stringPlus((String)"Query: ", (Object)uri);
            aCRALog.d(string, string2);
        }
        File bl = this.getFileForUri(uri);
        if (bl == null) {
            return null;
        }
        File file = bl;
        if (proj == null) {
            proj = COLUMNS;
        }
        Map columnValueMap = new LinkedHashMap();
        Iterator iterator = ArrayIteratorKt.iterator((Object[])proj);
        while (iterator.hasNext()) {
            boolean bl2;
            Object object;
            String string;
            Map map;
            String column = (String)iterator.next();
            if (Intrinsics.areEqual((Object)column, (Object)"_display_name")) {
                map = columnValueMap;
                string = "_display_name";
                object = file.getName();
                bl2 = false;
                map.put(string, object);
                continue;
            }
            if (!Intrinsics.areEqual((Object)column, (Object)"_size")) continue;
            map = columnValueMap;
            string = "_size";
            object = file.length();
            bl2 = false;
            map.put(string, object);
        }
        Collection $this$toTypedArray$iv = columnValueMap.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        MatrixCursor cursor = new MatrixCursor(stringArray, 1);
        cursor.addRow((Iterable)columnValueMap.values());
        return (Cursor)cursor;
    }

    private final File getFileForUri(Uri uri) {
        if (!Intrinsics.areEqual((Object)"content", (Object)uri.getScheme()) || !Intrinsics.areEqual((Object)this.authority, (Object)uri.getAuthority())) {
            return null;
        }
        List list = uri.getPathSegments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"uri.pathSegments");
        List segments = CollectionsKt.toMutableList((Collection)list);
        if (segments.size() < 2) {
            return null;
        }
        Object object = segments.remove(0);
        Intrinsics.checkNotNullExpressionValue(object, (String)"segments.removeAt(0)");
        object = (String)object;
        Object object2 = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"ROOT");
        boolean bl = false;
        Object object3 = object;
        boolean bl2 = false;
        String string = ((String)object3).toUpperCase((Locale)object2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toUpperCase(locale)");
        String dir = string;
        try {
            Directory directory = Directory.valueOf(dir);
            Context context = this.getContext();
            Intrinsics.checkNotNull((Object)context);
            object2 = context;
            Locale locale = object2;
            object2 = TextUtils.join((CharSequence)File.separator, (Iterable)segments);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"join(File.separator, segments)");
            object = directory.getFile((Context)locale, (String)object2);
        }
        catch (IllegalArgumentException e) {
            object = null;
        }
        return object;
    }

    @NotNull
    public String getType(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Companion.guessMimeType(uri);
    }

    @NotNull
    public Uri insert(@NotNull Uri uri, @Nullable ContentValues values) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        throw new UnsupportedOperationException("No insert supported");
    }

    public int delete(@NotNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        throw new UnsupportedOperationException("No delete supported");
    }

    public int update(@NotNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        throw new UnsupportedOperationException("No update supported");
    }

    @NotNull
    public ParcelFileDescriptor openFile(@NotNull Uri uri, @NotNull String mode) throws FileNotFoundException {
        File file;
        File file2;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        File file3 = this.getFileForUri(uri);
        if (file3 == null) {
            file2 = null;
        } else {
            File file4 = file3;
            boolean bl = false;
            boolean bl2 = false;
            File it = file4;
            boolean bl3 = false;
            file2 = file = it.exists() ? file4 : null;
        }
        if (file == null) {
            throw new FileNotFoundException("File represented by uri " + uri + " could not be found");
        }
        File file5 = file;
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = Build.VERSION.SDK_INT >= 19 ? this.getCallingPackage() + " opened " + file5.getPath() : Intrinsics.stringPlus((String)file5.getPath(), (Object)" was opened by an application");
            aCRALog.d(string, string2);
        }
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)file5, (int)0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)parcelFileDescriptor, (String)"open(file, ParcelFileDescriptor.MODE_READ_ONLY)");
        return parcelFileDescriptor;
    }

    @JvmStatic
    @NotNull
    public static final Uri getUriForFile(@NotNull Context context, @NotNull File file) {
        return Companion.getUriForFile(context, file);
    }

    @JvmStatic
    @NotNull
    public static final Uri getUriForFile(@NotNull Context context, @NotNull Directory directory, @NotNull String relativePath) {
        return Companion.getUriForFile(context, directory, relativePath);
    }

    @JvmStatic
    @NotNull
    public static final String guessMimeType(@NotNull Uri uri) {
        return Companion.guessMimeType(uri);
    }

    static {
        String[] stringArray = new String[]{"_display_name", "_size"};
        COLUMNS = stringArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0007J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\fH\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/acra/attachment/AcraContentProvider$Companion;", "", "()V", "COLUMNS", "", "", "[Ljava/lang/String;", "MIME_TYPE_OCTET_STREAM", "getAuthority", "context", "Landroid/content/Context;", "getUriForFile", "Landroid/net/Uri;", "file", "Ljava/io/File;", "directory", "Lorg/acra/file/Directory;", "relativePath", "guessMimeType", "uri", "acra-core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String getAuthority(Context context) {
            return Intrinsics.stringPlus((String)context.getPackageName(), (Object)".acra");
        }

        @JvmStatic
        @NotNull
        public final Uri getUriForFile(@NotNull Context context, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
            return this.getUriForFile(context, Directory.ROOT, string);
        }

        @JvmStatic
        @NotNull
        public final Uri getUriForFile(@NotNull Context context, @NotNull Directory directory, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)((Object)directory), (String)"directory");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Uri.Builder builder = new Uri.Builder().scheme("content").authority(this.getAuthority(context));
            Uri uri = directory.name();
            String[] stringArray = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"ROOT");
            boolean bl = false;
            Uri uri2 = uri;
            boolean bl2 = false;
            Uri uri3 = uri2;
            if (uri3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = uri3.toLowerCase((Locale)stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
            Uri.Builder builder2 = builder.appendPath(string);
            CharSequence charSequence = relativePath;
            stringArray = new String[1];
            String string2 = Pattern.quote(File.separator);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"quote(File.separator)");
            stringArray[0] = string2;
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Uri uri4 = thisCollection$iv.toArray(new String[0]);
            if (uri4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            for (String segment : uri4) {
                CharSequence charSequence2 = segment;
                boolean bl3 = false;
                if (!(charSequence2.length() > 0)) continue;
                builder2.appendPath(segment);
            }
            uri = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"builder.build()");
            return uri;
        }

        @JvmStatic
        @NotNull
        public final String guessMimeType(@NotNull Uri uri) {
            String string;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            String type = null;
            String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            if (fileExtension != null) {
                MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
                string = fileExtension;
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                boolean bl = false;
                String string2 = string;
                boolean bl2 = false;
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
                type = mimeTypeMap.getMimeTypeFromExtension(string3);
                if (type == null && Intrinsics.areEqual((Object)"json", (Object)fileExtension)) {
                    type = "application/json";
                }
            }
            return (string = type) == null ? AcraContentProvider.MIME_TYPE_OCTET_STREAM : string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

