/*
 * Decompiled with CFR 0.152.
 */
package org.acra;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.acra.ErrorReporter;
import org.acra.config.ACRAConfigurationException;
import org.acra.config.CoreConfiguration;
import org.acra.config.CoreConfigurationBuilder;
import org.acra.log.ACRALog;
import org.acra.log.AndroidLogDelegate;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.reporter.ErrorReporterImpl;
import org.acra.util.StreamReader;
import org.acra.util.StubCreator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0002J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020\u0006H\u0007J$\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010 \u001a\u00020\u0006H\u0007J\u0006\u0010#\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R&\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u00188\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/acra/ACRA;", "", "()V", "ACRA_PRIVATE_PROCESS_NAME", "", "DEV_LOGGING", "", "LOG_TAG", "PREF_ALWAYS_ACCEPT", "PREF_DISABLE_ACRA", "PREF_ENABLE_ACRA", "PREF_ENABLE_DEVICE_ID", "PREF_ENABLE_SYSTEM_LOGS", "PREF_LAST_VERSION_NR", "PREF_USER_EMAIL_ADDRESS", "<set-?>", "Lorg/acra/ErrorReporter;", "errorReporter", "getErrorReporter$annotations", "getErrorReporter", "()Lorg/acra/ErrorReporter;", "isInitialised", "()Z", "log", "Lorg/acra/log/ACRALog;", "currentProcessName", "init", "", "app", "Landroid/app/Application;", "config", "Lorg/acra/config/CoreConfiguration;", "checkReportsOnApplicationStart", "builder", "Lorg/acra/config/CoreConfigurationBuilder;", "isACRASenderServiceProcess", "acra-core_release"})
public final class ACRA {
    @NotNull
    public static final ACRA INSTANCE = new ACRA();
    @JvmField
    public static boolean DEV_LOGGING;
    @JvmField
    @NotNull
    public static final String LOG_TAG;
    @JvmField
    @NotNull
    public static ACRALog log;
    @NotNull
    private static final String ACRA_PRIVATE_PROCESS_NAME = ":acra";
    @NotNull
    public static final String PREF_DISABLE_ACRA = "acra.disable";
    @NotNull
    public static final String PREF_ENABLE_ACRA = "acra.enable";
    @NotNull
    public static final String PREF_ENABLE_SYSTEM_LOGS = "acra.syslog.enable";
    @NotNull
    public static final String PREF_ENABLE_DEVICE_ID = "acra.deviceid.enable";
    @NotNull
    public static final String PREF_USER_EMAIL_ADDRESS = "acra.user.email";
    @NotNull
    public static final String PREF_ALWAYS_ACCEPT = "acra.alwaysaccept";
    @NotNull
    public static final String PREF_LAST_VERSION_NR = "acra.lastVersionNr";
    @NotNull
    private static ErrorReporter errorReporter;

    private ACRA() {
    }

    @NotNull
    public static final ErrorReporter getErrorReporter() {
        return errorReporter;
    }

    @JvmStatic
    public static /* synthetic */ void getErrorReporter$annotations() {
    }

    @JvmStatic
    @JvmOverloads
    public static final void init(@NotNull Application app, @NotNull CoreConfigurationBuilder builder, boolean checkReportsOnApplicationStart) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        try {
            ACRA.init(app, builder.build(), checkReportsOnApplicationStart);
        }
        catch (ACRAConfigurationException e) {
            boolean $i$f$warn = false;
            String string = LOG_TAG;
            ACRALog aCRALog = log;
            boolean bl = false;
            String string2 = "Configuration Error - ACRA not started.";
            aCRALog.w(string, string2, e);
        }
    }

    public static /* synthetic */ void init$default(Application application, CoreConfigurationBuilder coreConfigurationBuilder, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            coreConfigurationBuilder = new CoreConfigurationBuilder((Context)application);
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        ACRA.init(application, coreConfigurationBuilder, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final void init(@NotNull Application app, @NotNull CoreConfiguration config, boolean checkReportsOnApplicationStart) {
        boolean $i$f$warn;
        boolean supportedAndroidVersion;
        String string;
        ACRALog aCRALog;
        String string2;
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean senderServiceProcess = INSTANCE.isACRASenderServiceProcess();
        if (senderServiceProcess) {
            boolean $i$f$debug = false;
            if (DEV_LOGGING) {
                string2 = LOG_TAG;
                aCRALog = log;
                boolean bl = false;
                string = "Not initialising ACRA to listen for uncaught Exceptions as this is the SendWorker process and we only send reports, we don't capture them to avoid infinite loops";
                aCRALog.d(string2, string);
            }
        }
        boolean bl = supportedAndroidVersion = Build.VERSION.SDK_INT >= 14;
        if (!supportedAndroidVersion) {
            $i$f$warn = false;
            string2 = LOG_TAG;
            aCRALog = log;
            boolean bl2 = false;
            string = "ACRA 5.1.0+ requires ICS or greater. ACRA is disabled and will NOT catch crashes or send messages.";
            aCRALog.w(string2, string);
        }
        if (INSTANCE.isInitialised()) {
            $i$f$warn = false;
            string2 = LOG_TAG;
            aCRALog = log;
            boolean bl3 = false;
            string = "ACRA#init called more than once. This might have unexpected side effects. Doing this outside of tests is discouraged.";
            aCRALog.w(string2, string);
            boolean $i$f$debug = false;
            if (DEV_LOGGING) {
                string2 = LOG_TAG;
                aCRALog = log;
                boolean bl4 = false;
                string = "Removing old ACRA config...";
                aCRALog.d(string2, string);
            }
            ((ErrorReporterImpl)errorReporter).unregister();
            errorReporter = StubCreator.INSTANCE.createErrorReporterStub();
        }
        SharedPreferences prefs = new SharedPreferencesFactory((Context)app, config).create();
        if (!senderServiceProcess) {
            boolean enableAcra = supportedAndroidVersion && SharedPreferencesFactory.Companion.shouldEnableACRA(prefs);
            boolean $i$f$info = false;
            string2 = LOG_TAG;
            aCRALog = log;
            boolean bl5 = false;
            string = "ACRA is " + (enableAcra ? "enabled" : "disabled") + " for " + app.getPackageName() + ", initializing...";
            aCRALog.i(string2, string);
            ErrorReporterImpl reporter = new ErrorReporterImpl(app, config, enableAcra, supportedAndroidVersion, checkReportsOnApplicationStart);
            errorReporter = reporter;
            prefs.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)reporter);
        }
    }

    public static /* synthetic */ void init$default(Application application, CoreConfiguration coreConfiguration, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        ACRA.init(application, coreConfiguration, bl);
    }

    public final boolean isInitialised() {
        return errorReporter instanceof ErrorReporterImpl;
    }

    public final boolean isACRASenderServiceProcess() {
        String processName = this.currentProcessName();
        boolean $i$f$debug = false;
        if (DEV_LOGGING) {
            String string = LOG_TAG;
            ACRALog aCRALog = log;
            boolean bl = false;
            String string2 = "ACRA processName='" + processName + '\'';
            aCRALog.d(string, string2);
        }
        return processName != null && StringsKt.endsWith$default((String)processName, (String)ACRA_PRIVATE_PROCESS_NAME, (boolean)false, (int)2, null);
    }

    private final String currentProcessName() {
        String string;
        try {
            String $this$trim$iv = new StreamReader("/proc/self/cmdline").read();
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        }
        catch (IOException e) {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @JvmOverloads
    public static final void init(@NotNull Application app, @NotNull CoreConfigurationBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        ACRA.init$default(app, builder, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void init(@NotNull Application app) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        ACRA.init$default(app, null, false, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void init(@NotNull Application app, @NotNull CoreConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ACRA.init$default(app, config, false, 4, null);
    }

    static {
        String string = ACRA.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ACRA::class.java.simpleName");
        LOG_TAG = string;
        log = new AndroidLogDelegate();
        errorReporter = StubCreator.INSTANCE.createErrorReporterStub();
    }
}

