/*
 * Decompiled with CFR 0.152.
 */
package org.acra.builder;

import android.content.Context;
import android.os.Debug;
import android.os.Looper;
import android.os.StrictMode;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.acra.ACRA;
import org.acra.ACRAConstants;
import org.acra.ReportField;
import org.acra.builder.LastActivityManager;
import org.acra.builder.ReportBuilder;
import org.acra.config.CoreConfiguration;
import org.acra.config.ReportingAdministrator;
import org.acra.data.CrashReportData;
import org.acra.data.CrashReportDataFactory;
import org.acra.file.CrashReportPersister;
import org.acra.file.ReportLocator;
import org.acra.interaction.ReportInteractionExecutor;
import org.acra.log.ACRALog;
import org.acra.plugins.PluginLoader;
import org.acra.scheduler.SchedulerStarter;
import org.acra.util.ProcessFinisher;
import org.acra.util.ToastSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001a\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0016\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001eJ\u0018\u0010)\u001a\u00020\u001a2\u0006\u0010*\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/acra/builder/ReportExecutor;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "crashReportDataFactory", "Lorg/acra/data/CrashReportDataFactory;", "defaultExceptionHandler", "Ljava/lang/Thread$UncaughtExceptionHandler;", "processFinisher", "Lorg/acra/util/ProcessFinisher;", "schedulerStarter", "Lorg/acra/scheduler/SchedulerStarter;", "lastActivityManager", "Lorg/acra/builder/LastActivityManager;", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;Lorg/acra/data/CrashReportDataFactory;Ljava/lang/Thread$UncaughtExceptionHandler;Lorg/acra/util/ProcessFinisher;Lorg/acra/scheduler/SchedulerStarter;Lorg/acra/builder/LastActivityManager;)V", "isEnabled", "", "()Z", "setEnabled", "(Z)V", "reportingAdministrators", "", "Lorg/acra/config/ReportingAdministrator;", "endApplication", "", "uncaughtExceptionThread", "Ljava/lang/Thread;", "th", "", "execute", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "getReportFileName", "Ljava/io/File;", "crashData", "Lorg/acra/data/CrashReportData;", "handReportToDefaultExceptionHandler", "t", "e", "saveCrashReportFile", "file", "sendReport", "report", "onlySendSilentReports", "acra-core_release"})
public final class ReportExecutor {
    private final List<ReportingAdministrator> reportingAdministrators;
    private boolean isEnabled;
    private final Context context;
    private final CoreConfiguration config;
    private final CrashReportDataFactory crashReportDataFactory;
    private final Thread.UncaughtExceptionHandler defaultExceptionHandler;
    private final ProcessFinisher processFinisher;
    private final SchedulerStarter schedulerStarter;
    private final LastActivityManager lastActivityManager;

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public final void handReportToDefaultExceptionHandler(@NotNull Thread t, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.defaultExceptionHandler != null) {
            boolean $i$f$info = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "ACRA is disabled for " + this.context.getPackageName() + " - forwarding uncaught Exception on to default ExceptionHandler";
            aCRALog.i(string, string2);
            this.defaultExceptionHandler.uncaughtException(t, e);
        } else {
            boolean $i$f$error = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string3 = "ACRA is disabled for " + this.context.getPackageName() + " - no default ExceptionHandler";
            aCRALog.e(string, string3);
            $i$f$error = false;
            string = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl2 = false;
            string3 = "ACRA caught a " + e.getClass().getSimpleName() + " for " + this.context.getPackageName();
            aCRALog.e(string, string3, e);
        }
    }

    public final void execute(@NotNull ReportBuilder reportBuilder) {
        boolean $i$f$warn;
        String string;
        ACRALog aCRALog;
        String string2;
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        if (!this.isEnabled) {
            boolean $i$f$warn2 = false;
            String string3 = ACRA.LOG_TAG;
            ACRALog aCRALog2 = ACRA.log;
            boolean bl = false;
            String string4 = "ACRA is disabled. Report not sent.";
            aCRALog2.w(string3, string4);
            return;
        }
        ReportingAdministrator blockingAdministrator = null;
        for (ReportingAdministrator administrator : this.reportingAdministrators) {
            try {
                if (administrator.shouldStartCollecting(this.context, this.config, reportBuilder)) continue;
                blockingAdministrator = administrator;
            }
            catch (Exception t) {
                boolean $i$f$warn3 = false;
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "ReportingAdministrator " + administrator.getClass().getName() + " threw exception";
                aCRALog.w(string2, string, t);
            }
        }
        CrashReportData crashReportData = null;
        if (blockingAdministrator == null) {
            crashReportData = this.crashReportDataFactory.createCrashData(reportBuilder);
            for (ReportingAdministrator administrator : this.reportingAdministrators) {
                try {
                    if (administrator.shouldSendReport(this.context, this.config, crashReportData)) continue;
                    blockingAdministrator = administrator;
                }
                catch (Exception t) {
                    boolean $i$f$warn4 = false;
                    string2 = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    string = "ReportingAdministrator " + administrator.getClass().getName() + " threw exception";
                    aCRALog.w(string2, string, t);
                }
            }
        } else {
            crashReportData = null;
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "Not collecting crash report because of ReportingAdministrator " + blockingAdministrator.getClass().getName();
                aCRALog.d(string2, string);
            }
        }
        if (reportBuilder.isEndApplication()) {
            boolean finishActivity = true;
            for (ReportingAdministrator administrator : this.reportingAdministrators) {
                try {
                    if (administrator.shouldFinishActivity(this.context, this.config, this.lastActivityManager)) continue;
                    finishActivity = false;
                }
                catch (Exception t) {
                    $i$f$warn = false;
                    string2 = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    string = "ReportingAdministrator " + administrator.getClass().getName() + " threw exception";
                    aCRALog.w(string2, string, t);
                }
            }
            if (finishActivity) {
                this.processFinisher.finishLastActivity(reportBuilder.getUncaughtExceptionThread());
            }
        }
        if (blockingAdministrator == null) {
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskWrites();
            CrashReportData crashReportData2 = crashReportData;
            Intrinsics.checkNotNull((Object)crashReportData2);
            File reportFile = this.getReportFileName(crashReportData2);
            this.saveCrashReportFile(reportFile, crashReportData);
            ReportInteractionExecutor executor = new ReportInteractionExecutor(this.context, this.config);
            if (reportBuilder.isSendSilently()) {
                this.sendReport(reportFile, executor.hasInteractions());
            } else if (executor.performInteractions(reportFile)) {
                this.sendReport(reportFile, false);
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        } else {
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "Not sending crash report because of ReportingAdministrator " + blockingAdministrator.getClass().getName();
                aCRALog.d(string2, string);
            }
            try {
                blockingAdministrator.notifyReportDropped(this.context, this.config);
            }
            catch (Exception t) {
                boolean $i$f$warn5 = false;
                string2 = ACRA.LOG_TAG;
                aCRALog = ACRA.log;
                boolean bl = false;
                string = "ReportingAdministrator " + blockingAdministrator.getClass().getName() + " threw exeption";
                aCRALog.w(string2, string, t);
            }
        }
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            string2 = ACRA.LOG_TAG;
            aCRALog = ACRA.log;
            boolean bl = false;
            string = "Wait for Interactions + worker ended. Kill Application ? " + reportBuilder.isEndApplication();
            aCRALog.d(string2, string);
        }
        if (reportBuilder.isEndApplication()) {
            boolean endApplication = true;
            for (ReportingAdministrator administrator : this.reportingAdministrators) {
                try {
                    if (administrator.shouldKillApplication(this.context, this.config, reportBuilder, crashReportData)) continue;
                    endApplication = false;
                }
                catch (Exception t) {
                    $i$f$warn = false;
                    string2 = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    string = "ReportingAdministrator " + administrator.getClass().getName() + " threw exception";
                    aCRALog.w(string2, string, t);
                }
            }
            if (endApplication) {
                if (Debug.isDebuggerConnected()) {
                    String warning = "Warning: Acra may behave differently with a debugger attached";
                    new Thread(new Runnable(this, warning){
                        final /* synthetic */ ReportExecutor this$0;
                        final /* synthetic */ String $warning;

                        public final void run() {
                            Looper.prepare();
                            ToastSender.sendToast(ReportExecutor.access$getContext$p(this.this$0), this.$warning, 1);
                            Looper.loop();
                        }
                        {
                            this.this$0 = reportExecutor;
                            this.$warning = string;
                        }
                    }).start();
                    boolean $i$f$warn6 = false;
                    string2 = ACRA.LOG_TAG;
                    aCRALog = ACRA.log;
                    boolean bl = false;
                    string = warning;
                    aCRALog.w(string2, string);
                } else {
                    Thread thread = reportBuilder.getUncaughtExceptionThread();
                    Throwable throwable = reportBuilder.getException();
                    if (throwable == null) {
                        throwable = new RuntimeException();
                    }
                    this.endApplication(thread, throwable);
                }
            }
        }
    }

    private final void endApplication(Thread uncaughtExceptionThread, Throwable th) {
        boolean letDefaultHandlerEndApplication = this.config.getAlsoReportToAndroidFramework();
        if (uncaughtExceptionThread != null && letDefaultHandlerEndApplication && this.defaultExceptionHandler != null) {
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string2 = "Handing Exception on to default ExceptionHandler";
                aCRALog.d(string, string2);
            }
            this.defaultExceptionHandler.uncaughtException(uncaughtExceptionThread, th);
        } else {
            this.processFinisher.endApplication();
        }
    }

    private final void sendReport(File report, boolean onlySendSilentReports) {
        if (this.isEnabled) {
            this.schedulerStarter.scheduleReports(report, onlySendSilentReports);
        } else {
            boolean $i$f$warn = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "Would be sending reports, but ACRA is disabled";
            aCRALog.w(string, string2);
        }
    }

    private final File getReportFileName(CrashReportData crashData) {
        String timestamp = crashData.getString(ReportField.USER_CRASH_DATE);
        String isSilent = crashData.getString(ReportField.IS_SILENT);
        String fileName = timestamp + (isSilent != null && Boolean.parseBoolean(isSilent) ? ACRAConstants.SILENT_SUFFIX : "") + ".stacktrace";
        ReportLocator reportLocator = new ReportLocator(this.context);
        return new File(reportLocator.getUnapprovedFolder(), fileName);
    }

    private final void saveCrashReportFile(File file, CrashReportData crashData) {
        try {
            boolean $i$f$debug = false;
            if (ACRA.DEV_LOGGING) {
                String string = ACRA.LOG_TAG;
                ACRALog aCRALog = ACRA.log;
                boolean bl = false;
                String string2 = "Writing crash report file " + file;
                aCRALog.d(string, string2);
            }
            new CrashReportPersister().store(crashData, file);
        }
        catch (Exception e) {
            boolean $i$f$error = false;
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string3 = "An error occurred while writing the report file...";
            aCRALog.e(string, string3, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ReportExecutor(@NotNull Context context, @NotNull CoreConfiguration config, @NotNull CrashReportDataFactory crashReportDataFactory, @Nullable Thread.UncaughtExceptionHandler defaultExceptionHandler, @NotNull ProcessFinisher processFinisher, @NotNull SchedulerStarter schedulerStarter, @NotNull LastActivityManager lastActivityManager) {
        void $this$loadEnabled$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)crashReportDataFactory, (String)"crashReportDataFactory");
        Intrinsics.checkNotNullParameter((Object)processFinisher, (String)"processFinisher");
        Intrinsics.checkNotNullParameter((Object)schedulerStarter, (String)"schedulerStarter");
        Intrinsics.checkNotNullParameter((Object)lastActivityManager, (String)"lastActivityManager");
        this.context = context;
        this.config = config;
        this.crashReportDataFactory = crashReportDataFactory;
        this.defaultExceptionHandler = defaultExceptionHandler;
        this.processFinisher = processFinisher;
        this.schedulerStarter = schedulerStarter;
        this.lastActivityManager = lastActivityManager;
        PluginLoader pluginLoader = this.config.getPluginLoader();
        CoreConfiguration config$iv = this.config;
        boolean $i$f$loadEnabled = false;
        this.reportingAdministrators = $this$loadEnabled$iv.loadEnabled(config$iv, ReportingAdministrator.class);
    }

    public static final /* synthetic */ Context access$getContext$p(ReportExecutor $this) {
        return $this.context;
    }
}

