/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.app.ActivityManager;
import android.app.NotificationManager;
import android.content.Context;
import android.os.DropBoxManager;
import android.telephony.TelephonyManager;
import androidx.annotation.NonNull;

public final class SystemServices {
    private SystemServices() {
    }

    @NonNull
    public static TelephonyManager getTelephonyManager(@NonNull Context context) throws ServiceNotReachedException {
        return (TelephonyManager)SystemServices.getService(context, "phone");
    }

    @NonNull
    public static DropBoxManager getDropBoxManager(@NonNull Context context) throws ServiceNotReachedException {
        return (DropBoxManager)SystemServices.getService(context, "dropbox");
    }

    @NonNull
    public static NotificationManager getNotificationManager(@NonNull Context context) throws ServiceNotReachedException {
        return (NotificationManager)SystemServices.getService(context, "notification");
    }

    @NonNull
    public static ActivityManager getActivityManager(@NonNull Context context) throws ServiceNotReachedException {
        return (ActivityManager)SystemServices.getService(context, "activity");
    }

    @NonNull
    private static Object getService(@NonNull Context context, @NonNull String id) throws ServiceNotReachedException {
        Object service = context.getSystemService(id);
        if (service == null) {
            throw new ServiceNotReachedException("Unable to load SystemService " + id);
        }
        return service;
    }

    static class ServiceNotReachedException
    extends Exception {
        ServiceNotReachedException(String message) {
            super(message);
        }
    }
}

