/*
 * Decompiled with CFR 0.152.
 */
package org.acra.plugins;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.plugins.Plugin;
import org.acra.plugins.PluginLoader;

public class SimplePluginLoader
implements PluginLoader {
    private final Class<? extends Plugin>[] plugins;

    @SafeVarargs
    public SimplePluginLoader(Class<? extends Plugin> ... plugins) {
        this.plugins = plugins;
    }

    @Override
    public <T extends Plugin> List<T> load(@NonNull Class<T> clazz) {
        ArrayList<Plugin> list = new ArrayList<Plugin>();
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "SimplePluginLoader loading services from plugin classes : " + this.plugins);
        }
        for (Class<? extends Plugin> plugin : this.plugins) {
            if (!clazz.isAssignableFrom(plugin)) continue;
            try {
                list.add(plugin.newInstance());
                if (!ACRA.DEV_LOGGING) continue;
                ACRA.log.d(ACRA.LOG_TAG, "Loaded plugin from class : " + plugin);
            }
            catch (Exception e) {
                if (!ACRA.DEV_LOGGING) continue;
                ACRA.log.w(ACRA.LOG_TAG, "Could not load plugin from class : " + plugin, e);
            }
        }
        return list;
    }

    @Override
    public <T extends Plugin> List<T> loadEnabled(@NonNull CoreConfiguration config, @NonNull Class<T> clazz) {
        List<T> list = this.load(clazz);
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)iterator.next();
            if (plugin.enabled(config)) continue;
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Removing disabled plugin : " + plugin);
            }
            iterator.remove();
        }
        return list;
    }
}

