/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import androidx.annotation.NonNull;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ReflectionCollector
extends BaseReportFieldCollector {
    public ReflectionCollector() {
        super(ReportField.BUILD, ReportField.BUILD_CONFIG, ReportField.ENVIRONMENT);
    }

    @Override
    void collect(@NonNull ReportField reportField, @NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) throws JSONException, ClassNotFoundException {
        JSONObject result = new JSONObject();
        switch (reportField) {
            case BUILD: {
                ReflectionCollector.collectConstants(Build.class, result);
                JSONObject version = new JSONObject();
                ReflectionCollector.collectConstants(Build.VERSION.class, version);
                result.put("VERSION", (Object)version);
                break;
            }
            case BUILD_CONFIG: {
                ReflectionCollector.collectConstants(this.getBuildConfigClass(context, config), result);
                break;
            }
            case ENVIRONMENT: {
                this.collectStaticGettersResults(Environment.class, result);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        target.put(reportField, result);
    }

    private static void collectConstants(@NonNull Class<?> someClass, @NonNull JSONObject container) throws JSONException {
        Field[] fields;
        for (Field field : fields = someClass.getFields()) {
            try {
                Object value = field.get(null);
                if (value == null) continue;
                if (field.getType().isArray()) {
                    container.put(field.getName(), (Object)new JSONArray(Arrays.asList((Object[])value)));
                    continue;
                }
                container.put(field.getName(), value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private void collectStaticGettersResults(@NonNull Class<?> someClass, @NonNull JSONObject container) throws JSONException {
        Method[] methods;
        for (Method method : methods = someClass.getMethods()) {
            if (method.getParameterTypes().length != 0 || !method.getName().startsWith("get") && !method.getName().startsWith("is") || "getClass".equals(method.getName())) continue;
            try {
                container.put(method.getName(), method.invoke(null, (Object[])null));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @NonNull
    private Class<?> getBuildConfigClass(@NonNull Context context, @NonNull CoreConfiguration config) throws ClassNotFoundException {
        Class configuredBuildConfig = config.buildConfigClass();
        if (!configuredBuildConfig.equals(Object.class)) {
            return configuredBuildConfig;
        }
        String className = context.getPackageName() + ".BuildConfig";
        return Class.forName(className);
    }
}

