/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collections.ImmutableList;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.util.PackageManagerWrapper;
import org.acra.util.Predicate;
import org.acra.util.StreamReader;

public final class LogCatCollector
extends BaseReportFieldCollector {
    private static final int READ_TIMEOUT = 3000;

    public LogCatCollector() {
        super(ReportField.LOGCAT, ReportField.EVENTSLOG, ReportField.RADIOLOG);
    }

    @Override
    @NonNull
    public Collector.Order getOrder() {
        return Collector.Order.FIRST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String collectLogCat(@NonNull CoreConfiguration config, @Nullable String bufferName) throws IOException {
        ImmutableList<String> logcatArgumentsList;
        int tailIndex;
        int myPid = android.os.Process.myPid();
        String myPidStr = Build.VERSION.SDK_INT < 16 && config.logcatFilterByPid() && myPid > 0 ? Integer.toString(myPid) + "):" : null;
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add("logcat");
        if (bufferName != null) {
            commandLine.add("-b");
            commandLine.add(bufferName);
        }
        int tailCount = (tailIndex = (logcatArgumentsList = config.logcatArguments()).indexOf("-t")) > -1 && tailIndex < logcatArgumentsList.size() ? Integer.parseInt((String)logcatArgumentsList.get(tailIndex + 1)) : -1;
        commandLine.addAll((Collection<String>)logcatArgumentsList);
        Process process = new ProcessBuilder(new String[0]).command(commandLine).redirectErrorStream(true).start();
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Retrieving logcat output (buffer:" + (bufferName == null ? "default" : bufferName) + ")...");
        }
        try {
            String string = this.streamToString(config, process.getInputStream(), myPidStr == null ? null : s -> s.contains(myPidStr), tailCount);
            return string;
        }
        finally {
            process.destroy();
        }
    }

    @Override
    boolean shouldCollect(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportField collect, @NonNull ReportBuilder reportBuilder) {
        return super.shouldCollect(context, config, collect, reportBuilder) && (Build.VERSION.SDK_INT >= 16 || new PackageManagerWrapper(context).hasPermission("android.permission.READ_LOGS")) && new SharedPreferencesFactory(context, config).create().getBoolean("acra.syslog.enable", true);
    }

    @Override
    void collect(@NonNull ReportField reportField, @NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) throws IOException {
        String bufferName = null;
        switch (reportField) {
            case LOGCAT: {
                bufferName = null;
                break;
            }
            case EVENTSLOG: {
                bufferName = "events";
                break;
            }
            case RADIOLOG: {
                bufferName = "radio";
            }
        }
        target.put(reportField, this.collectLogCat(config, bufferName));
    }

    @NonNull
    private String streamToString(@NonNull CoreConfiguration config, @NonNull InputStream input, @Nullable Predicate<String> filter, int limit) throws IOException {
        StreamReader reader = new StreamReader(input).setFilter(filter).setLimit(limit);
        if (config.logcatReadNonBlocking()) {
            reader.setTimeout(3000);
        }
        return reader.read();
    }
}

