/*
 * Decompiled with CFR 0.152.
 */
package org.acra.attachment;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import org.acra.ACRA;
import org.acra.file.Directory;

public class AcraContentProvider
extends ContentProvider {
    private static final String[] COLUMNS = new String[]{"_display_name", "_size"};
    private static final String MIME_TYPE_OCTET_STREAM = "application/octet-stream";
    private String authority;

    public boolean onCreate() {
        this.authority = AcraContentProvider.getAuthority(this.getContext());
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Registered content provider for authority " + this.authority);
        }
        return true;
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        File file;
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Query: " + uri);
        }
        if ((file = this.getFileForUri(uri)) == null) {
            return null;
        }
        if (projection == null) {
            projection = COLUMNS;
        }
        LinkedHashMap<String, Object> columnValueMap = new LinkedHashMap<String, Object>();
        for (String column : projection) {
            if (column.equals("_display_name")) {
                columnValueMap.put("_display_name", file.getName());
                continue;
            }
            if (!column.equals("_size")) continue;
            columnValueMap.put("_size", file.length());
        }
        MatrixCursor cursor = new MatrixCursor(columnValueMap.keySet().toArray(new String[columnValueMap.size()]), 1);
        cursor.addRow(columnValueMap.values());
        return cursor;
    }

    @Nullable
    private File getFileForUri(@NonNull Uri uri) {
        if (!"content".equals(uri.getScheme()) || !this.authority.equals(uri.getAuthority())) {
            return null;
        }
        ArrayList segments = new ArrayList(uri.getPathSegments());
        if (segments.size() < 2) {
            return null;
        }
        String dir = ((String)segments.remove(0)).toUpperCase();
        try {
            Directory directory = Directory.valueOf(dir);
            return directory.getFile(this.getContext(), TextUtils.join((CharSequence)File.separator, segments));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @NonNull
    public String getType(@NonNull Uri uri) {
        return AcraContentProvider.guessMimeType(uri);
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        throw new UnsupportedOperationException("No insert supported");
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        throw new UnsupportedOperationException("No delete supported");
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        throw new UnsupportedOperationException("No update supported");
    }

    @NonNull
    public ParcelFileDescriptor openFile(@NonNull Uri uri, @NonNull String mode) throws FileNotFoundException {
        File file = this.getFileForUri(uri);
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("File represented by uri " + uri + " could not be found");
        }
        if (ACRA.DEV_LOGGING) {
            if (Build.VERSION.SDK_INT >= 19) {
                ACRA.log.d(ACRA.LOG_TAG, this.getCallingPackage() + " opened " + file.getPath());
            } else {
                ACRA.log.d(ACRA.LOG_TAG, file.getPath() + " was opened by an application");
            }
        }
        return ParcelFileDescriptor.open((File)file, (int)0x10000000);
    }

    @NonNull
    private static String getAuthority(@NonNull Context context) {
        return context.getPackageName() + ".acra";
    }

    @NonNull
    public static Uri getUriForFile(@NonNull Context context, @NonNull File file) {
        return AcraContentProvider.getUriForFile(context, Directory.ROOT, file.getPath());
    }

    @NonNull
    public static Uri getUriForFile(@NonNull Context context, @NonNull Directory directory, @NonNull String relativePath) {
        Uri.Builder builder = new Uri.Builder().scheme("content").authority(AcraContentProvider.getAuthority(context)).appendPath(directory.name().toLowerCase());
        for (String segment : relativePath.split(Pattern.quote(File.separator))) {
            if (segment.length() <= 0) continue;
            builder.appendPath(segment);
        }
        return builder.build();
    }

    @NonNull
    public static String guessMimeType(@NonNull Uri uri) {
        String type = null;
        String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
        if (fileExtension != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension.toLowerCase());
        }
        if (type == null) {
            type = MIME_TYPE_OCTET_STREAM;
        }
        return type;
    }
}

