/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import androidx.annotation.NonNull;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.acra.ACRA;
import org.acra.ErrorReporter;

public final class StubCreator {
    private StubCreator() {
    }

    @NonNull
    public static ErrorReporter createErrorReporterStub() {
        return StubCreator.createStub(ErrorReporter.class, (proxy, method, args) -> {
            String message = ACRA.isACRASenderServiceProcess() ? "in SenderService process" : "before ACRA#init (if you did call #init, check if your configuration is valid)";
            ACRA.log.w(ACRA.LOG_TAG, String.format("ErrorReporter#%s called %s. THIS CALL WILL BE IGNORED!", method.getName(), message));
            return null;
        });
    }

    @NonNull
    public static <T> T createStub(Class<T> interfaceClass, InvocationHandler handler) {
        return (T)Proxy.newProxyInstance(StubCreator.class.getClassLoader(), new Class[]{interfaceClass}, handler);
    }
}

