/*
 * Decompiled with CFR 0.152.
 */
package org.acra.startup;

import android.content.Context;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.acra.config.CoreConfiguration;
import org.acra.file.LastModifiedComparator;
import org.acra.startup.Report;
import org.acra.startup.StartupProcessor;

public class UnapprovedStartupProcessor
implements StartupProcessor {
    @Override
    public void processReports(@NonNull Context context, @NonNull CoreConfiguration config, List<Report> reports) {
        if (config.deleteUnapprovedReportsOnApplicationStart()) {
            ArrayList<Report> sort = new ArrayList<Report>();
            for (Report report : reports) {
                if (report.isApproved()) continue;
                sort.add(report);
            }
            if (!sort.isEmpty()) {
                LastModifiedComparator comparator = new LastModifiedComparator();
                Collections.sort(sort, (r1, r2) -> comparator.compare(r1.getFile(), r2.getFile()));
                if (config.deleteUnapprovedReportsOnApplicationStart()) {
                    for (int i = 0; i < sort.size() - 1; ++i) {
                        ((Report)sort.get(i)).delete();
                    }
                }
                ((Report)sort.get(sort.size() - 1)).approve();
            }
        }
    }
}

