/*
 * Decompiled with CFR 0.152.
 */
package org.acra.scheduler;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.File;
import java.util.List;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.file.ReportLocator;
import org.acra.scheduler.DefaultSenderScheduler;
import org.acra.scheduler.SenderScheduler;
import org.acra.scheduler.SenderSchedulerFactory;

public class SchedulerStarter {
    private final ReportLocator locator;
    private final SenderScheduler senderScheduler;

    public SchedulerStarter(@NonNull Context context, @NonNull CoreConfiguration config) {
        this.locator = new ReportLocator(context);
        List<SenderSchedulerFactory> schedulerFactories = config.pluginLoader().loadEnabled(config, SenderSchedulerFactory.class);
        if (schedulerFactories.isEmpty()) {
            this.senderScheduler = new DefaultSenderScheduler(context, config);
        } else {
            this.senderScheduler = schedulerFactories.get(0).create(context, config);
            if (schedulerFactories.size() > 1) {
                ACRA.log.w(ACRA.LOG_TAG, "More than one SenderScheduler found. Will use only " + this.senderScheduler.getClass().getSimpleName());
            }
        }
    }

    public void scheduleReports(@Nullable File report, boolean onlySendSilentReports) {
        if (report != null) {
            File approvedReport;
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Mark " + report.getName() + " as approved.");
            }
            if (!report.renameTo(approvedReport = new File(this.locator.getApprovedFolder(), report.getName()))) {
                ACRA.log.w(ACRA.LOG_TAG, "Could not rename approved report from " + report + " to " + approvedReport);
            }
        }
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Schedule report sending");
        }
        this.senderScheduler.scheduleReportSending(onlySendSilentReports);
    }

    public SenderScheduler getSenderScheduler() {
        return this.senderScheduler;
    }
}

