/*
 * Decompiled with CFR 0.152.
 */
package org.acra.data;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.collections.ImmutableSet;
import org.acra.data.StringFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class CrashReportData {
    private final JSONObject content;

    public CrashReportData() {
        this.content = new JSONObject();
    }

    public CrashReportData(String json) throws JSONException {
        this.content = new JSONObject(json);
    }

    public synchronized void put(@NonNull String key, boolean value) {
        try {
            this.content.put(key, value);
        }
        catch (JSONException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Failed to put value into CrashReportData: " + String.valueOf(value));
        }
    }

    public synchronized void put(@NonNull String key, double value) {
        try {
            this.content.put(key, value);
        }
        catch (JSONException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Failed to put value into CrashReportData: " + String.valueOf(value));
        }
    }

    public synchronized void put(@NonNull String key, int value) {
        try {
            this.content.put(key, value);
        }
        catch (JSONException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Failed to put value into CrashReportData: " + String.valueOf(value));
        }
    }

    public synchronized void put(@NonNull String key, long value) {
        try {
            this.content.put(key, value);
        }
        catch (JSONException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Failed to put value into CrashReportData: " + String.valueOf(value));
        }
    }

    public synchronized void put(@NonNull String key, @Nullable String value) {
        if (value == null) {
            this.putNA(key);
            return;
        }
        try {
            this.content.put(key, (Object)value);
        }
        catch (JSONException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Failed to put value into CrashReportData: " + value);
        }
    }

    public synchronized void put(@NonNull String key, @Nullable JSONObject value) {
        if (value == null) {
            this.putNA(key);
            return;
        }
        try {
            this.content.put(key, (Object)value);
        }
        catch (JSONException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Failed to put value into CrashReportData: " + String.valueOf(value));
        }
    }

    public synchronized void put(@NonNull String key, @Nullable JSONArray value) {
        if (value == null) {
            this.putNA(key);
            return;
        }
        try {
            this.content.put(key, (Object)value);
        }
        catch (JSONException e) {
            ACRA.log.w(ACRA.LOG_TAG, "Failed to put value into CrashReportData: " + String.valueOf(value));
        }
    }

    public synchronized void put(@NonNull ReportField key, boolean value) {
        this.put(key.toString(), value);
    }

    public synchronized void put(@NonNull ReportField key, double value) {
        this.put(key.toString(), value);
    }

    public synchronized void put(@NonNull ReportField key, int value) {
        this.put(key.toString(), value);
    }

    public synchronized void put(@NonNull ReportField key, long value) {
        this.put(key.toString(), value);
    }

    public synchronized void put(@NonNull ReportField key, @Nullable String value) {
        this.put(key.toString(), value);
    }

    public synchronized void put(@NonNull ReportField key, @Nullable JSONObject value) {
        this.put(key.toString(), value);
    }

    public synchronized void put(@NonNull ReportField key, @Nullable JSONArray value) {
        this.put(key.toString(), value);
    }

    private void putNA(@NonNull String key) {
        try {
            this.content.put(key, (Object)"N/A");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public String getString(@NonNull ReportField key) {
        return this.content.optString(key.toString());
    }

    public Object get(@NonNull String key) {
        return this.content.opt(key);
    }

    public boolean containsKey(@NonNull String key) {
        return this.content.has(key);
    }

    public boolean containsKey(@NonNull ReportField key) {
        return this.containsKey(key.toString());
    }

    @NonNull
    public String toJSON() throws JSONException {
        try {
            return StringFormat.JSON.toFormattedString(this, (ImmutableSet<ReportField>)ImmutableSet.empty(), "", "", false);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage());
        }
    }

    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.content.length());
        Iterator iterator = this.content.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            map.put(key, this.get(key));
        }
        return map;
    }
}

