/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;

public final class StacktraceCollector
extends BaseReportFieldCollector {
    public StacktraceCollector() {
        super(ReportField.STACK_TRACE, ReportField.STACK_TRACE_HASH);
    }

    @Override
    @NonNull
    public Collector.Order getOrder() {
        return Collector.Order.FIRST;
    }

    @Override
    void collect(@NonNull ReportField reportField, @NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) {
        switch (reportField) {
            case STACK_TRACE: {
                target.put(ReportField.STACK_TRACE, this.getStackTrace(reportBuilder.getMessage(), reportBuilder.getException()));
                break;
            }
            case STACK_TRACE_HASH: {
                target.put(ReportField.STACK_TRACE_HASH, this.getStackTraceHash(reportBuilder.getException()));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    boolean shouldCollect(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportField collect, @NonNull ReportBuilder reportBuilder) {
        return collect == ReportField.STACK_TRACE || super.shouldCollect(context, config, collect, reportBuilder);
    }

    @NonNull
    private String getStackTrace(@Nullable String msg, @Nullable Throwable th) {
        StringWriter result = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(result);){
            if (msg != null && !TextUtils.isEmpty((CharSequence)msg)) {
                printWriter.println(msg);
            }
            if (th != null) {
                th.printStackTrace(printWriter);
            }
            String string = ((Object)result).toString();
            return string;
        }
    }

    @NonNull
    private String getStackTraceHash(@Nullable Throwable th) {
        StringBuilder res = new StringBuilder();
        for (Throwable cause = th; cause != null; cause = cause.getCause()) {
            StackTraceElement[] stackTraceElements;
            for (StackTraceElement e : stackTraceElements = cause.getStackTrace()) {
                res.append(e.getClassName());
                res.append(e.getMethodName());
            }
        }
        return Integer.toHexString(res.toString().hashCode());
    }
}

