/*
 * Decompiled with CFR 0.152.
 */
package org.acra.builder;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.acra.ACRA;
import org.acra.collections.WeakStack;

public final class LastActivityManager {
    @NonNull
    private final WeakStack<Activity> activityStack = new WeakStack();

    public LastActivityManager(@NonNull Application application) {
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NonNull Activity activity, Bundle savedInstanceState) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivityCreated " + activity.getClass());
                }
                LastActivityManager.this.activityStack.add((Object)activity);
            }

            public void onActivityStarted(@NonNull Activity activity) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivityStarted " + activity.getClass());
                }
            }

            public void onActivityResumed(@NonNull Activity activity) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivityResumed " + activity.getClass());
                }
            }

            public void onActivityPaused(@NonNull Activity activity) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivityPaused " + activity.getClass());
                }
            }

            public void onActivityStopped(@NonNull Activity activity) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivityStopped " + activity.getClass());
                }
            }

            public void onActivitySaveInstanceState(@NonNull Activity activity, Bundle outState) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivitySaveInstanceState " + activity.getClass());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onActivityDestroyed(@NonNull Activity activity) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivityDestroyed " + activity.getClass());
                }
                WeakStack weakStack = LastActivityManager.this.activityStack;
                synchronized (weakStack) {
                    LastActivityManager.this.activityStack.remove((Object)activity);
                    LastActivityManager.this.activityStack.notify();
                }
            }
        });
    }

    @Nullable
    public Activity getLastActivity() {
        return (Activity)this.activityStack.peek();
    }

    @NonNull
    public List<Activity> getLastActivities() {
        return new ArrayList<Activity>((Collection<Activity>)this.activityStack);
    }

    public void clearLastActivities() {
        this.activityStack.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllActivitiesDestroy(int timeOutInMillis) {
        WeakStack<Activity> weakStack = this.activityStack;
        synchronized (weakStack) {
            long start;
            long now = start = System.currentTimeMillis();
            while (!this.activityStack.isEmpty() && start + (long)timeOutInMillis > now) {
                try {
                    this.activityStack.wait(start - now + (long)timeOutInMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
        }
    }
}

