/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.json.JSONException;
import org.json.JSONObject;

public final class DeviceFeaturesCollector
extends BaseReportFieldCollector {
    public DeviceFeaturesCollector() {
        super(ReportField.DEVICE_FEATURES, new ReportField[0]);
    }

    @Override
    void collect(@NonNull ReportField reportField, @NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) throws JSONException {
        FeatureInfo[] features;
        JSONObject result = new JSONObject();
        PackageManager pm = context.getPackageManager();
        for (FeatureInfo feature : features = pm.getSystemAvailableFeatures()) {
            String featureName = feature.name;
            if (featureName != null) {
                result.put(featureName, true);
                continue;
            }
            result.put("glEsVersion", (Object)feature.getGlEsVersion());
        }
        target.put(ReportField.DEVICE_FEATURES, result);
    }
}

