/*
 * Decompiled with CFR 0.152.
 */
package org.acra.startup;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.file.CrashReportFileNameParser;
import org.acra.file.ReportLocator;
import org.acra.interaction.ReportInteractionExecutor;
import org.acra.scheduler.SchedulerStarter;
import org.acra.startup.Report;
import org.acra.startup.StartupProcessor;

public class StartupProcessorExecutor {
    private final Context context;
    private final CoreConfiguration config;
    private final ReportLocator reportLocator;
    private final SchedulerStarter schedulerStarter;
    private final CrashReportFileNameParser fileNameParser;

    public StartupProcessorExecutor(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull SchedulerStarter schedulerStarter) {
        this.context = context;
        this.config = config;
        this.reportLocator = new ReportLocator(context);
        this.schedulerStarter = schedulerStarter;
        this.fileNameParser = new CrashReportFileNameParser();
    }

    public void processReports(boolean isAcraEnabled) {
        Calendar now = Calendar.getInstance();
        new Handler(this.context.getMainLooper()).post(() -> new Thread(() -> {
            ArrayList<Report> reports = new ArrayList<Report>();
            for (File r : this.reportLocator.getUnapprovedReports()) {
                reports.add(new Report(r, false));
            }
            for (File r : this.reportLocator.getApprovedReports()) {
                reports.add(new Report(r, true));
            }
            List<StartupProcessor> startupProcessors = this.config.pluginLoader().loadEnabled(this.config, StartupProcessor.class);
            for (StartupProcessor processor : startupProcessors) {
                processor.processReports(this.context, this.config, reports);
            }
            boolean send = false;
            for (Report report : reports) {
                if (!this.fileNameParser.getTimestamp(report.getFile().getName()).before(now)) continue;
                if (report.isDelete()) {
                    if (report.getFile().delete()) continue;
                    ACRA.log.w(ACRA.LOG_TAG, "Could not delete report " + report.getFile());
                    continue;
                }
                if (report.isApproved()) {
                    send = true;
                    continue;
                }
                if (!report.isApprove() || !isAcraEnabled) continue;
                new ReportInteractionExecutor(this.context, this.config).performInteractions(report.getFile());
            }
            if (send && isAcraEnabled) {
                this.schedulerStarter.scheduleReports(null, false);
            }
        }).start());
    }
}

