/*
 * Decompiled with CFR 0.152.
 */
package org.acra.interaction;

import android.content.Context;
import android.support.annotation.NonNull;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.interaction.ReportInteraction;

public class ReportInteractionExecutor {
    private final List<ReportInteraction> reportInteractions;
    private final Context context;
    private final CoreConfiguration config;

    public ReportInteractionExecutor(@NonNull Context context, @NonNull CoreConfiguration config) {
        this.context = context;
        this.config = config;
        this.reportInteractions = config.pluginLoader().loadEnabled(config, ReportInteraction.class);
    }

    public boolean hasInteractions() {
        return this.reportInteractions.size() > 0;
    }

    public boolean performInteractions(@NonNull File reportFile) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        for (ReportInteraction reportInteraction : this.reportInteractions) {
            futures.add(executorService.submit(() -> {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "Calling ReportInteraction of class " + reportInteraction.getClass().getName());
                }
                return reportInteraction.performInteraction(this.context, this.config, reportFile);
            }));
        }
        boolean sendReports = true;
        block4: for (Future future : futures) {
            while (!future.isDone()) {
                try {
                    sendReports &= ((Boolean)future.get()).booleanValue();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    continue block4;
                }
            }
        }
        return sendReports;
    }
}

