/*
 * Decompiled with CFR 0.152.
 */
package org.acra.file;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.NonNull;
import java.io.File;
import java.util.regex.Pattern;

public enum Directory {
    FILES_LEGACY{

        @Override
        @NonNull
        public File getFile(@NonNull Context context, @NonNull String fileName) {
            return (fileName.startsWith("/") ? ROOT : FILES).getFile(context, fileName);
        }
    }
    ,
    FILES{

        @Override
        @NonNull
        public File getFile(@NonNull Context context, @NonNull String fileName) {
            return new File(context.getFilesDir(), fileName);
        }
    }
    ,
    EXTERNAL_FILES{

        @Override
        @NonNull
        public File getFile(@NonNull Context context, @NonNull String fileName) {
            return new File(context.getExternalFilesDir(null), fileName);
        }
    }
    ,
    CACHE{

        @Override
        @NonNull
        public File getFile(@NonNull Context context, @NonNull String fileName) {
            return new File(context.getCacheDir(), fileName);
        }
    }
    ,
    EXTERNAL_CACHE{

        @Override
        @NonNull
        public File getFile(@NonNull Context context, @NonNull String fileName) {
            return new File(context.getExternalCacheDir(), fileName);
        }
    }
    ,
    NO_BACKUP_FILES{

        @Override
        @NonNull
        public File getFile(@NonNull Context context, @NonNull String fileName) {
            File dir = Build.VERSION.SDK_INT >= 21 ? context.getNoBackupFilesDir() : new File(context.getApplicationInfo().dataDir, "no_backup");
            return new File(dir, fileName);
        }
    }
    ,
    EXTERNAL_STORAGE{

        @Override
        @NonNull
        public File getFile(@NonNull Context context, @NonNull String fileName) {
            return new File(Environment.getExternalStorageDirectory(), fileName);
        }
    }
    ,
    ROOT{

        @Override
        @NonNull
        public File getFile(@NonNull Context context, @NonNull String fileName) {
            File[] roots;
            String[] parts = fileName.split(Pattern.quote(File.separator), 2);
            if (parts.length == 1) {
                return new File(fileName);
            }
            for (File root : roots = File.listRoots()) {
                if (!parts[0].equals(root.getPath().replace(File.separator, ""))) continue;
                return new File(root, parts[1]);
            }
            return new File(roots[0], fileName);
        }
    };


    @NonNull
    public abstract File getFile(@NonNull Context var1, @NonNull String var2);
}

