/*
 * Decompiled with CFR 0.152.
 */
package org.acra.data;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.acra.ReportField;
import org.acra.collections.ImmutableSet;
import org.acra.data.CrashReportData;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public enum StringFormat {
    JSON("application/json"){

        @Override
        @NonNull
        public String toFormattedString(@NonNull CrashReportData data, @NonNull ImmutableSet<ReportField> order, @NonNull String mainJoiner, @NonNull String subJoiner, boolean urlEncode) throws JSONException {
            Map<String, Object> map = data.toMap();
            JSONStringer stringer = new JSONStringer().object();
            for (ReportField field : order) {
                stringer.key(field.toString()).value(map.remove(field.toString()));
            }
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                stringer.key(entry.getKey()).value(entry.getValue());
            }
            return stringer.endObject().toString();
        }
    }
    ,
    KEY_VALUE_LIST("application/x-www-form-urlencoded"){

        @Override
        @NonNull
        public String toFormattedString(@NonNull CrashReportData data, @NonNull ImmutableSet<ReportField> order, @NonNull String mainJoiner, @NonNull String subJoiner, boolean urlEncode) throws UnsupportedEncodingException {
            Map<String, String> map = this.toStringMap(data.toMap(), subJoiner);
            StringBuilder builder = new StringBuilder();
            for (ReportField field : order) {
                this.append(builder, field.toString(), map.remove(field.toString()), mainJoiner, urlEncode);
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.append(builder, entry.getKey(), entry.getValue(), mainJoiner, urlEncode);
            }
            return builder.toString();
        }

        private void append(@NonNull StringBuilder builder, @Nullable String key, @Nullable String value, @Nullable String joiner, boolean urlEncode) throws UnsupportedEncodingException {
            if (builder.length() > 0) {
                builder.append(joiner);
            }
            if (urlEncode) {
                key = key != null ? URLEncoder.encode(key, "UTF-8") : null;
                value = value != null ? URLEncoder.encode(value, "UTF-8") : null;
            }
            builder.append(key).append('=').append(value);
        }

        @NonNull
        private Map<String, String> toStringMap(@NonNull Map<String, Object> map, @NonNull String joiner) {
            HashMap<String, String> stringMap = new HashMap<String, String>(map.size());
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                stringMap.put(entry.getKey(), this.valueToString(joiner, entry.getValue()));
            }
            return stringMap;
        }

        private String valueToString(@NonNull String joiner, @Nullable Object value) {
            if (value instanceof JSONObject) {
                return TextUtils.join((CharSequence)joiner, this.flatten((JSONObject)value));
            }
            return String.valueOf(value);
        }

        @NonNull
        private List<String> flatten(@NonNull JSONObject json) {
            ArrayList<String> result = new ArrayList<String>();
            Iterator iterator = json.keys();
            while (iterator.hasNext()) {
                Object value;
                String key = (String)iterator.next();
                try {
                    value = json.get(key);
                }
                catch (JSONException e) {
                    value = null;
                }
                if (value instanceof JSONObject) {
                    for (String s : this.flatten((JSONObject)value)) {
                        result.add(key + "." + s);
                    }
                    continue;
                }
                result.add(key + "=" + value);
            }
            return result;
        }
    };

    private final String contentType;

    private StringFormat(String contentType) {
        this.contentType = contentType;
    }

    @NonNull
    public abstract String toFormattedString(@NonNull CrashReportData var1, @NonNull ImmutableSet<ReportField> var2, @NonNull String var3, @NonNull String var4, boolean var5) throws Exception;

    @NonNull
    public String getMatchingHttpContentType() {
        return this.contentType;
    }
}

