/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.os.Build;
import android.os.DropBoxManager;
import android.support.annotation.NonNull;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collections.ImmutableList;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.prefs.SharedPreferencesFactory;
import org.acra.util.PackageManagerWrapper;
import org.acra.util.SystemServices;
import org.json.JSONException;
import org.json.JSONObject;

public final class DropBoxCollector
extends BaseReportFieldCollector {
    private static final String[] SYSTEM_TAGS = new String[]{"system_app_anr", "system_app_wtf", "system_app_crash", "system_server_anr", "system_server_wtf", "system_server_crash", "BATTERY_DISCHARGE_INFO", "SYSTEM_RECOVERY_LOG", "SYSTEM_BOOT", "SYSTEM_LAST_KMSG", "APANIC_CONSOLE", "APANIC_THREADS", "SYSTEM_RESTART", "SYSTEM_TOMBSTONE", "data_app_strictmode"};
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss", Locale.getDefault());

    public DropBoxCollector() {
        super(ReportField.DROPBOX, new ReportField[0]);
    }

    @Override
    @NonNull
    public Collector.Order getOrder() {
        return Collector.Order.FIRST;
    }

    @Override
    void collect(@NonNull ReportField reportField, @NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) throws Exception {
        ImmutableList<String> additionalTags;
        DropBoxManager dropbox = SystemServices.getDropBoxManager(context);
        Calendar calendar = Calendar.getInstance();
        calendar.roll(12, -config.dropboxCollectionMinutes());
        long time = calendar.getTimeInMillis();
        this.dateFormat.format(calendar.getTime());
        ArrayList<String> tags = new ArrayList<String>();
        if (config.includeDropBoxSystemTags()) {
            tags.addAll(Arrays.asList(SYSTEM_TAGS));
        }
        if (!(additionalTags = config.additionalDropBoxTags()).isEmpty()) {
            tags.addAll((Collection<String>)additionalTags);
        }
        if (!tags.isEmpty()) {
            JSONObject dropboxContent = new JSONObject();
            for (String tag : tags) {
                StringBuilder builder = new StringBuilder();
                DropBoxManager.Entry entry = dropbox.getNextEntry(tag, time);
                if (entry == null) {
                    builder.append("Nothing.").append('\n');
                    continue;
                }
                while (entry != null) {
                    long msec = entry.getTimeMillis();
                    calendar.setTimeInMillis(msec);
                    builder.append('@').append(this.dateFormat.format(calendar.getTime())).append('\n');
                    String text = entry.getText(500);
                    if (text != null) {
                        builder.append("Text: ").append(text).append('\n');
                    } else {
                        builder.append("Not Text!").append('\n');
                    }
                    entry.close();
                    entry = dropbox.getNextEntry(tag, msec);
                }
                try {
                    dropboxContent.put(tag, (Object)builder.toString());
                }
                catch (JSONException e) {
                    ACRA.log.w(ACRA.LOG_TAG, "Failed to collect data for tag " + tag, e);
                }
            }
            target.put(ReportField.DROPBOX, dropboxContent);
        }
    }

    @Override
    boolean shouldCollect(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportField collect, @NonNull ReportBuilder reportBuilder) {
        return super.shouldCollect(context, config, collect, reportBuilder) && (Build.VERSION.SDK_INT >= 16 || new PackageManagerWrapper(context).hasPermission("android.permission.READ_LOGS")) && new SharedPreferencesFactory(context, config).create().getBoolean("acra.syslog.enable", true);
    }
}

