/*
 * Decompiled with CFR 0.152.
 */
package org.acra.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.acra.ACRA;

public final class InstanceCreator {
    @NonNull
    public <T> T create(@NonNull Class<? extends T> clazz, @NonNull Fallback<T> fallback) {
        T t = this.create(clazz);
        return t != null ? t : fallback.get();
    }

    @VisibleForTesting
    @Nullable
    <T> T create(@NonNull Class<? extends T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            ACRA.log.e(ACRA.LOG_TAG, "Failed to create instance of class " + clazz.getName(), e);
        }
        catch (IllegalAccessException e) {
            ACRA.log.e(ACRA.LOG_TAG, "Failed to create instance of class " + clazz.getName(), e);
        }
        return null;
    }

    @NonNull
    public <T> List<T> create(@NonNull Collection<Class<? extends T>> classes) {
        ArrayList<T> result = new ArrayList<T>();
        for (Class<T> clazz : classes) {
            T instance = this.create(clazz);
            if (instance == null) continue;
            result.add(instance);
        }
        return result;
    }

    @FunctionalInterface
    public static interface Fallback<T> {
        @NonNull
        public T get();
    }
}

