/*
 * Decompiled with CFR 0.152.
 */
package org.acra.legacy;

import android.content.Context;
import android.support.annotation.NonNull;
import java.io.File;
import java.io.FilenameFilter;
import org.acra.ACRA;
import org.acra.file.CrashReportFileNameParser;
import org.acra.file.ReportLocator;

final class ReportMigrator {
    private final Context context;
    private final CrashReportFileNameParser fileNameParser = new CrashReportFileNameParser();
    private final ReportLocator reportLocator;

    ReportMigrator(@NonNull Context context) {
        this.context = context;
        this.reportLocator = new ReportLocator(context);
    }

    void migrate() {
        File[] reportFiles;
        ACRA.log.i(ACRA.LOG_TAG, "Migrating unsent ACRA reports to new file locations");
        for (File file : reportFiles = this.getCrashReportFiles()) {
            String fileName = file.getName();
            if (this.fileNameParser.isApproved(fileName)) {
                if (!file.renameTo(new File(this.reportLocator.getApprovedFolder(), fileName)) || !ACRA.DEV_LOGGING) continue;
                ACRA.log.d(ACRA.LOG_TAG, "Cold not migrate unsent ACRA crash report : " + fileName);
                continue;
            }
            if (!file.renameTo(new File(this.reportLocator.getUnapprovedFolder(), fileName)) || !ACRA.DEV_LOGGING) continue;
            ACRA.log.d(ACRA.LOG_TAG, "Cold not migrate unsent ACRA crash report : " + fileName);
        }
        ACRA.log.i(ACRA.LOG_TAG, "Migrated " + reportFiles.length + " unsent reports");
    }

    @NonNull
    private File[] getCrashReportFiles() {
        FilenameFilter filter;
        File[] result;
        File dir = this.context.getFilesDir();
        if (dir == null) {
            ACRA.log.w(ACRA.LOG_TAG, "Application files directory does not exist! The application may not be installed correctly. Please try reinstalling.");
            return new File[0];
        }
        if (ACRA.DEV_LOGGING) {
            ACRA.log.d(ACRA.LOG_TAG, "Looking for error files in " + dir.getAbsolutePath());
        }
        return (result = dir.listFiles(filter = (dir1, name) -> name.endsWith(".stacktrace"))) == null ? new File[]{} : result;
    }
}

