/*
 * Decompiled with CFR 0.152.
 */
package org.acra.file;

import android.support.annotation.NonNull;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.acra.ACRAConstants;

public final class CrashReportFileNameParser {
    public boolean isSilent(@NonNull String reportFileName) {
        return reportFileName.contains(ACRAConstants.SILENT_SUFFIX);
    }

    @Deprecated
    public boolean isApproved(@NonNull String reportFileName) {
        return this.isSilent(reportFileName) || reportFileName.contains("-approved");
    }

    @NonNull
    public Calendar getTimestamp(@NonNull String reportFileName) {
        String timestamp = reportFileName.replace(".stacktrace", "").replace(ACRAConstants.SILENT_SUFFIX, "");
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ", Locale.ENGLISH).parse(timestamp));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return calendar;
    }
}

