/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import java.util.List;
import java.util.Set;
import org.acra.ReportField;
import org.acra.annotation.AcraCore;
import org.acra.attachment.AttachmentUriProvider;
import org.acra.attachment.DefaultAttachmentProvider;
import org.acra.config.ACRAConfigurationException;
import org.acra.config.BaseCoreConfigurationBuilder;
import org.acra.config.ClassValidator;
import org.acra.config.Configuration;
import org.acra.config.ConfigurationBuilder;
import org.acra.config.CoreConfiguration;
import org.acra.config.DefaultRetryPolicy;
import org.acra.config.RetryPolicy;
import org.acra.data.StringFormat;
import org.acra.file.Directory;
import org.acra.plugins.PluginLoader;
import org.acra.sender.ReportSenderFactory;

public final class CoreConfigurationBuilder
implements ConfigurationBuilder {
    @NonNull
    private final Context context;
    private boolean enabled;
    @NonNull
    private String sharedPreferencesName;
    private boolean includeDropBoxSystemTags;
    @NonNull
    private String[] additionalDropBoxTags;
    private int dropboxCollectionMinutes;
    @NonNull
    private String[] logcatArguments;
    @NonNull
    private ReportField[] reportContent;
    private boolean deleteUnapprovedReportsOnApplicationStart;
    private boolean deleteOldUnsentReportsOnApplicationStart;
    private boolean alsoReportToAndroidFramework;
    @NonNull
    private String[] additionalSharedPreferences;
    private boolean logcatFilterByPid;
    private boolean logcatReadNonBlocking;
    private boolean sendReportsInDevMode;
    @NonNull
    private String[] excludeMatchingSharedPreferencesKeys;
    @NonNull
    private String[] excludeMatchingSettingsKeys;
    @NonNull
    private Class buildConfigClass;
    @Deprecated
    @NonNull
    private Class<? extends ReportSenderFactory>[] reportSenderFactoryClasses;
    @NonNull
    private String applicationLogFile;
    private int applicationLogFileLines;
    @NonNull
    private Directory applicationLogFileDir;
    @NonNull
    private Class<? extends RetryPolicy> retryPolicyClass;
    private boolean stopServicesOnCrash;
    @NonNull
    private String[] attachmentUris;
    @NonNull
    private Class<? extends AttachmentUriProvider> attachmentUriProvider;
    @Nullable
    private String reportSendSuccessToast;
    @Nullable
    private String reportSendFailureToast;
    @NonNull
    private StringFormat reportFormat;
    private boolean parallel;
    @NonNull
    private final BaseCoreConfigurationBuilder delegate;

    public CoreConfigurationBuilder(@NonNull Context arg0) {
        AcraCore annotation = arg0.getClass().getAnnotation(AcraCore.class);
        this.context = arg0;
        this.enabled = annotation != null;
        this.delegate = new BaseCoreConfigurationBuilder(arg0);
        if (this.enabled) {
            this.sharedPreferencesName = annotation.sharedPreferencesName();
            this.includeDropBoxSystemTags = annotation.includeDropBoxSystemTags();
            this.additionalDropBoxTags = annotation.additionalDropBoxTags();
            this.dropboxCollectionMinutes = annotation.dropboxCollectionMinutes();
            this.logcatArguments = annotation.logcatArguments();
            this.reportContent = annotation.reportContent();
            this.deleteUnapprovedReportsOnApplicationStart = annotation.deleteUnapprovedReportsOnApplicationStart();
            this.deleteOldUnsentReportsOnApplicationStart = annotation.deleteOldUnsentReportsOnApplicationStart();
            this.alsoReportToAndroidFramework = annotation.alsoReportToAndroidFramework();
            this.additionalSharedPreferences = annotation.additionalSharedPreferences();
            this.logcatFilterByPid = annotation.logcatFilterByPid();
            this.logcatReadNonBlocking = annotation.logcatReadNonBlocking();
            this.sendReportsInDevMode = annotation.sendReportsInDevMode();
            this.excludeMatchingSharedPreferencesKeys = annotation.excludeMatchingSharedPreferencesKeys();
            this.excludeMatchingSettingsKeys = annotation.excludeMatchingSettingsKeys();
            this.buildConfigClass = annotation.buildConfigClass();
            this.reportSenderFactoryClasses = annotation.reportSenderFactoryClasses();
            this.applicationLogFile = annotation.applicationLogFile();
            this.applicationLogFileLines = annotation.applicationLogFileLines();
            this.applicationLogFileDir = annotation.applicationLogFileDir();
            this.retryPolicyClass = annotation.retryPolicyClass();
            this.stopServicesOnCrash = annotation.stopServicesOnCrash();
            this.attachmentUris = annotation.attachmentUris();
            this.attachmentUriProvider = annotation.attachmentUriProvider();
            if (annotation.resReportSendSuccessToast() != 0) {
                this.reportSendSuccessToast = this.context.getString(annotation.resReportSendSuccessToast());
            }
            if (annotation.resReportSendFailureToast() != 0) {
                this.reportSendFailureToast = this.context.getString(annotation.resReportSendFailureToast());
            }
            this.reportFormat = annotation.reportFormat();
            this.parallel = annotation.parallel();
        } else {
            this.sharedPreferencesName = "";
            this.includeDropBoxSystemTags = false;
            this.additionalDropBoxTags = new String[0];
            this.dropboxCollectionMinutes = 5;
            this.logcatArguments = new String[]{"-t", "100", "-v", "time"};
            this.reportContent = new ReportField[0];
            this.deleteUnapprovedReportsOnApplicationStart = true;
            this.deleteOldUnsentReportsOnApplicationStart = true;
            this.alsoReportToAndroidFramework = false;
            this.additionalSharedPreferences = new String[0];
            this.logcatFilterByPid = true;
            this.logcatReadNonBlocking = false;
            this.sendReportsInDevMode = true;
            this.excludeMatchingSharedPreferencesKeys = new String[0];
            this.excludeMatchingSettingsKeys = new String[0];
            this.buildConfigClass = Object.class;
            this.reportSenderFactoryClasses = new Class[0];
            this.applicationLogFile = "";
            this.applicationLogFileLines = 100;
            this.applicationLogFileDir = Directory.FILES_LEGACY;
            this.retryPolicyClass = DefaultRetryPolicy.class;
            this.stopServicesOnCrash = false;
            this.attachmentUris = new String[0];
            this.attachmentUriProvider = DefaultAttachmentProvider.class;
            this.reportFormat = StringFormat.JSON;
            this.parallel = true;
        }
    }

    @NonNull
    public CoreConfigurationBuilder setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    boolean enabled() {
        return this.enabled;
    }

    @NonNull
    public CoreConfigurationBuilder setSharedPreferencesName(@NonNull String sharedPreferencesName) {
        this.sharedPreferencesName = sharedPreferencesName;
        return this;
    }

    @NonNull
    String sharedPreferencesName() {
        return this.sharedPreferencesName;
    }

    @NonNull
    public CoreConfigurationBuilder setIncludeDropBoxSystemTags(boolean includeDropBoxSystemTags) {
        this.includeDropBoxSystemTags = includeDropBoxSystemTags;
        return this;
    }

    boolean includeDropBoxSystemTags() {
        return this.includeDropBoxSystemTags;
    }

    @NonNull
    public CoreConfigurationBuilder setAdditionalDropBoxTags(String ... additionalDropBoxTags) {
        this.additionalDropBoxTags = additionalDropBoxTags;
        return this;
    }

    @NonNull
    String[] additionalDropBoxTags() {
        return this.additionalDropBoxTags;
    }

    @NonNull
    public CoreConfigurationBuilder setDropboxCollectionMinutes(int dropboxCollectionMinutes) {
        this.dropboxCollectionMinutes = dropboxCollectionMinutes;
        return this;
    }

    int dropboxCollectionMinutes() {
        return this.dropboxCollectionMinutes;
    }

    @NonNull
    public CoreConfigurationBuilder setLogcatArguments(String ... logcatArguments) {
        this.logcatArguments = logcatArguments;
        return this;
    }

    @NonNull
    String[] logcatArguments() {
        return this.logcatArguments;
    }

    @NonNull
    public CoreConfigurationBuilder setReportContent(ReportField ... reportContent) {
        this.reportContent = reportContent;
        return this;
    }

    @NonNull
    Set<ReportField> reportContent() {
        return this.delegate.transformReportContent(this.reportContent);
    }

    @NonNull
    public CoreConfigurationBuilder setDeleteUnapprovedReportsOnApplicationStart(boolean deleteUnapprovedReportsOnApplicationStart) {
        this.deleteUnapprovedReportsOnApplicationStart = deleteUnapprovedReportsOnApplicationStart;
        return this;
    }

    boolean deleteUnapprovedReportsOnApplicationStart() {
        return this.deleteUnapprovedReportsOnApplicationStart;
    }

    @NonNull
    public CoreConfigurationBuilder setDeleteOldUnsentReportsOnApplicationStart(boolean deleteOldUnsentReportsOnApplicationStart) {
        this.deleteOldUnsentReportsOnApplicationStart = deleteOldUnsentReportsOnApplicationStart;
        return this;
    }

    boolean deleteOldUnsentReportsOnApplicationStart() {
        return this.deleteOldUnsentReportsOnApplicationStart;
    }

    @NonNull
    public CoreConfigurationBuilder setAlsoReportToAndroidFramework(boolean alsoReportToAndroidFramework) {
        this.alsoReportToAndroidFramework = alsoReportToAndroidFramework;
        return this;
    }

    boolean alsoReportToAndroidFramework() {
        return this.alsoReportToAndroidFramework;
    }

    @NonNull
    public CoreConfigurationBuilder setAdditionalSharedPreferences(String ... additionalSharedPreferences) {
        this.additionalSharedPreferences = additionalSharedPreferences;
        return this;
    }

    @NonNull
    String[] additionalSharedPreferences() {
        return this.additionalSharedPreferences;
    }

    @NonNull
    public CoreConfigurationBuilder setLogcatFilterByPid(boolean logcatFilterByPid) {
        this.logcatFilterByPid = logcatFilterByPid;
        return this;
    }

    boolean logcatFilterByPid() {
        return this.logcatFilterByPid;
    }

    @NonNull
    public CoreConfigurationBuilder setLogcatReadNonBlocking(boolean logcatReadNonBlocking) {
        this.logcatReadNonBlocking = logcatReadNonBlocking;
        return this;
    }

    boolean logcatReadNonBlocking() {
        return this.logcatReadNonBlocking;
    }

    @NonNull
    public CoreConfigurationBuilder setSendReportsInDevMode(boolean sendReportsInDevMode) {
        this.sendReportsInDevMode = sendReportsInDevMode;
        return this;
    }

    boolean sendReportsInDevMode() {
        return this.sendReportsInDevMode;
    }

    @NonNull
    public CoreConfigurationBuilder setExcludeMatchingSharedPreferencesKeys(String ... excludeMatchingSharedPreferencesKeys) {
        this.excludeMatchingSharedPreferencesKeys = excludeMatchingSharedPreferencesKeys;
        return this;
    }

    @NonNull
    String[] excludeMatchingSharedPreferencesKeys() {
        return this.excludeMatchingSharedPreferencesKeys;
    }

    @NonNull
    public CoreConfigurationBuilder setExcludeMatchingSettingsKeys(String ... excludeMatchingSettingsKeys) {
        this.excludeMatchingSettingsKeys = excludeMatchingSettingsKeys;
        return this;
    }

    @NonNull
    String[] excludeMatchingSettingsKeys() {
        return this.excludeMatchingSettingsKeys;
    }

    @NonNull
    public CoreConfigurationBuilder setBuildConfigClass(@NonNull Class buildConfigClass) {
        this.buildConfigClass = buildConfigClass;
        return this;
    }

    @NonNull
    Class buildConfigClass() {
        return this.buildConfigClass;
    }

    @Deprecated
    @NonNull
    public CoreConfigurationBuilder setReportSenderFactoryClasses(Class<? extends ReportSenderFactory> ... reportSenderFactoryClasses) {
        this.reportSenderFactoryClasses = reportSenderFactoryClasses;
        return this;
    }

    @Deprecated
    @NonNull
    Class<? extends ReportSenderFactory>[] reportSenderFactoryClasses() {
        return this.reportSenderFactoryClasses;
    }

    @NonNull
    public CoreConfigurationBuilder setApplicationLogFile(@NonNull String applicationLogFile) {
        this.applicationLogFile = applicationLogFile;
        return this;
    }

    @NonNull
    String applicationLogFile() {
        return this.applicationLogFile;
    }

    @NonNull
    public CoreConfigurationBuilder setApplicationLogFileLines(int applicationLogFileLines) {
        this.applicationLogFileLines = applicationLogFileLines;
        return this;
    }

    int applicationLogFileLines() {
        return this.applicationLogFileLines;
    }

    @NonNull
    public CoreConfigurationBuilder setApplicationLogFileDir(@NonNull Directory applicationLogFileDir) {
        this.applicationLogFileDir = applicationLogFileDir;
        return this;
    }

    @NonNull
    Directory applicationLogFileDir() {
        return this.applicationLogFileDir;
    }

    @NonNull
    public CoreConfigurationBuilder setRetryPolicyClass(@NonNull Class<? extends RetryPolicy> retryPolicyClass) {
        this.retryPolicyClass = retryPolicyClass;
        return this;
    }

    @NonNull
    Class<? extends RetryPolicy> retryPolicyClass() {
        return this.retryPolicyClass;
    }

    @NonNull
    public CoreConfigurationBuilder setStopServicesOnCrash(boolean stopServicesOnCrash) {
        this.stopServicesOnCrash = stopServicesOnCrash;
        return this;
    }

    boolean stopServicesOnCrash() {
        return this.stopServicesOnCrash;
    }

    @NonNull
    public CoreConfigurationBuilder setAttachmentUris(String ... attachmentUris) {
        this.attachmentUris = attachmentUris;
        return this;
    }

    @NonNull
    String[] attachmentUris() {
        return this.attachmentUris;
    }

    @NonNull
    public CoreConfigurationBuilder setAttachmentUriProvider(@NonNull Class<? extends AttachmentUriProvider> attachmentUriProvider) {
        this.attachmentUriProvider = attachmentUriProvider;
        return this;
    }

    @NonNull
    Class<? extends AttachmentUriProvider> attachmentUriProvider() {
        return this.attachmentUriProvider;
    }

    @NonNull
    public CoreConfigurationBuilder setReportSendSuccessToast(@Nullable String reportSendSuccessToast) {
        this.reportSendSuccessToast = reportSendSuccessToast;
        return this;
    }

    @NonNull
    public CoreConfigurationBuilder setResReportSendSuccessToast(@StringRes int resReportSendSuccessToast) {
        this.reportSendSuccessToast = this.context.getString(resReportSendSuccessToast);
        return this;
    }

    @Nullable
    String reportSendSuccessToast() {
        return this.reportSendSuccessToast;
    }

    @NonNull
    public CoreConfigurationBuilder setReportSendFailureToast(@Nullable String reportSendFailureToast) {
        this.reportSendFailureToast = reportSendFailureToast;
        return this;
    }

    @NonNull
    public CoreConfigurationBuilder setResReportSendFailureToast(@StringRes int resReportSendFailureToast) {
        this.reportSendFailureToast = this.context.getString(resReportSendFailureToast);
        return this;
    }

    @Nullable
    String reportSendFailureToast() {
        return this.reportSendFailureToast;
    }

    @NonNull
    public CoreConfigurationBuilder setReportFormat(@NonNull StringFormat reportFormat) {
        this.reportFormat = reportFormat;
        return this;
    }

    @NonNull
    StringFormat reportFormat() {
        return this.reportFormat;
    }

    @NonNull
    public CoreConfigurationBuilder setParallel(boolean parallel) {
        this.parallel = parallel;
        return this;
    }

    boolean parallel() {
        return this.parallel;
    }

    @NonNull
    public CoreConfigurationBuilder setPluginLoader(PluginLoader pluginLoader) {
        this.delegate.setPluginLoader(pluginLoader);
        return this;
    }

    @NonNull
    PluginLoader pluginLoader() {
        return this.delegate.pluginLoader();
    }

    @NonNull
    public CoreConfigurationBuilder setReportField(ReportField field, boolean enable) {
        this.delegate.setReportField(field, enable);
        return this;
    }

    @NonNull
    List<Configuration> pluginConfigurations() {
        return this.delegate.pluginConfigurations();
    }

    @NonNull
    public <R extends ConfigurationBuilder> R getPluginConfigurationBuilder(Class<R> c) {
        return this.delegate.getPluginConfigurationBuilder(c);
    }

    @NonNull
    public CoreConfiguration build() throws ACRAConfigurationException {
        if (this.enabled) {
            ClassValidator.check((Class[])this.reportSenderFactoryClasses);
            ClassValidator.check((Class[])new Class[]{this.retryPolicyClass});
            ClassValidator.check((Class[])new Class[]{this.attachmentUriProvider});
        }
        this.delegate.preBuild();
        return new CoreConfiguration(this);
    }
}

