/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.acra.ACRA;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.json.JSONObject;

public final class SettingsCollector
extends BaseReportFieldCollector {
    private static final String ERROR = "Error: ";

    public SettingsCollector() {
        super(ReportField.SETTINGS_SYSTEM, ReportField.SETTINGS_SECURE, ReportField.SETTINGS_GLOBAL);
    }

    @Override
    void collect(@NonNull ReportField reportField, @NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) throws Exception {
        switch (reportField) {
            case SETTINGS_SYSTEM: {
                target.put(ReportField.SETTINGS_SYSTEM, this.collectSettings(context, config, Settings.System.class));
                break;
            }
            case SETTINGS_SECURE: {
                target.put(ReportField.SETTINGS_SECURE, this.collectSettings(context, config, Settings.Secure.class));
                break;
            }
            case SETTINGS_GLOBAL: {
                target.put(ReportField.SETTINGS_GLOBAL, Build.VERSION.SDK_INT >= 17 ? this.collectSettings(context, config, Settings.Global.class) : null);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @NonNull
    private JSONObject collectSettings(@NonNull Context context, @NonNull CoreConfiguration config, @NonNull Class<?> settings) throws NoSuchMethodException {
        JSONObject result = new JSONObject();
        Field[] keys = settings.getFields();
        Method getString = settings.getMethod("getString", ContentResolver.class, String.class);
        for (Field key : keys) {
            if (key.isAnnotationPresent(Deprecated.class) || key.getType() != String.class || !this.isAuthorized(config, key)) continue;
            try {
                Object value = getString.invoke(null, context.getContentResolver(), key.get(null));
                if (value == null) continue;
                result.put(key.getName(), value);
            }
            catch (Exception e) {
                ACRA.log.w(ACRA.LOG_TAG, ERROR, e);
            }
        }
        return result;
    }

    private boolean isAuthorized(@NonNull CoreConfiguration config, @Nullable Field key) {
        if (key == null || key.getName().startsWith("WIFI_AP")) {
            return false;
        }
        for (String regex : config.excludeMatchingSettingsKeys()) {
            if (!key.getName().matches(regex)) continue;
            return false;
        }
        return true;
    }
}

