/*
 * Decompiled with CFR 0.152.
 */
package org.acra.builder;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.lang.ref.WeakReference;
import org.acra.ACRA;

public final class LastActivityManager {
    @NonNull
    private WeakReference<Activity> lastActivityCreated = new WeakReference<Object>(null);

    public LastActivityManager(@NonNull Application application) {
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NonNull Activity activity, Bundle savedInstanceState) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivityCreated " + activity.getClass());
                }
                LastActivityManager.this.lastActivityCreated = new WeakReference<Activity>(activity);
            }

            public void onActivityStarted(@NonNull Activity activity) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivityStarted " + activity.getClass());
                }
            }

            public void onActivityResumed(@NonNull Activity activity) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivityResumed " + activity.getClass());
                }
            }

            public void onActivityPaused(@NonNull Activity activity) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivityPaused " + activity.getClass());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onActivityStopped(@NonNull Activity activity) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivityStopped " + activity.getClass());
                }
                1 var2_2 = this;
                synchronized (var2_2) {
                    this.notify();
                }
            }

            public void onActivitySaveInstanceState(@NonNull Activity activity, Bundle outState) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivitySaveInstanceState " + activity.getClass());
                }
            }

            public void onActivityDestroyed(@NonNull Activity activity) {
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "onActivityDestroyed " + activity.getClass());
                }
            }
        });
    }

    @Nullable
    public Activity getLastActivity() {
        return (Activity)this.lastActivityCreated.get();
    }

    public void clearLastActivity() {
        this.lastActivityCreated.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForActivityStop(int timeOutInMillis) {
        LastActivityManager lastActivityManager = this;
        synchronized (lastActivityManager) {
            try {
                this.wait(timeOutInMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

