/*
 * Decompiled with CFR 0.152.
 */
package org.acra.plugins;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.acra.config.CoreConfiguration;
import org.acra.plugins.Plugin;
import org.acra.plugins.PluginLoader;

public class SimplePluginLoader
implements PluginLoader {
    private final Class<? extends Plugin>[] plugins;

    @SafeVarargs
    public SimplePluginLoader(Class<? extends Plugin> ... plugins) {
        this.plugins = plugins;
    }

    @Override
    public <T extends Plugin> List<T> load(@NonNull Class<T> clazz) {
        ArrayList<Plugin> list = new ArrayList<Plugin>();
        for (Class<? extends Plugin> plugin : this.plugins) {
            if (!clazz.isAssignableFrom(plugin)) continue;
            try {
                list.add(plugin.newInstance());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    @Override
    public <T extends Plugin> List<T> loadEnabled(@NonNull CoreConfiguration config, @NonNull Class<T> clazz) {
        List<T> list = this.load(clazz);
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((Plugin)iterator.next()).enabled(config)) continue;
            iterator.remove();
        }
        return list;
    }
}

