/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import com.google.auto.service.AutoService;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/acra/collector/ThreadCollector;", "Lorg/acra/collector/BaseReportFieldCollector;", "<init>", "()V", "order", "Lorg/acra/collector/Collector$Order;", "getOrder", "()Lorg/acra/collector/Collector$Order;", "collect", "", "reportField", "Lorg/acra/ReportField;", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "reportBuilder", "Lorg/acra/builder/ReportBuilder;", "target", "Lorg/acra/data/CrashReportData;", "acra-core_release"})
@AutoService(value={Collector.class})
@SourceDebugExtension(value={"SMAP\nThreadCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadCollector.kt\norg/acra/collector/ThreadCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public class ThreadCollector
extends BaseReportFieldCollector {
    public ThreadCollector() {
        ReportField[] reportFieldArray = new ReportField[]{ReportField.THREAD_DETAILS};
        super(reportFieldArray);
    }

    @Override
    @NotNull
    public Collector.Order getOrder() {
        return Collector.Order.LATE;
    }

    @Override
    public void collect(@NotNull ReportField reportField, @NotNull Context context, @NotNull CoreConfiguration config, @NotNull ReportBuilder reportBuilder, @NotNull CrashReportData target) throws Exception {
        Intrinsics.checkNotNullParameter((Object)((Object)reportField), (String)"reportField");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)reportBuilder, (String)"reportBuilder");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Thread t = reportBuilder.getUncaughtExceptionThread();
        if (t != null) {
            JSONObject result = new JSONObject();
            result.put("id", t.getId());
            result.put("name", (Object)t.getName());
            result.put("priority", t.getPriority());
            ThreadGroup threadGroup = t.getThreadGroup();
            if (threadGroup != null) {
                ThreadGroup it = threadGroup;
                boolean bl = false;
                result.put("groupName", (Object)it);
            }
            target.put(ReportField.THREAD_DETAILS, result);
        } else {
            target.put(ReportField.THREAD_DETAILS, (String)null);
        }
    }
}

