/*
 * Decompiled with CFR 0.152.
 */
package org.acra.attachment;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.acra.ACRA;
import org.acra.file.Directory;
import org.acra.log.ACRALog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016JK\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J/\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u001aJ9\u0010\u001b\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u0005H\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/acra/attachment/AcraContentProvider;", "Landroid/content/ContentProvider;", "<init>", "()V", "authority", "", "onCreate", "", "query", "Landroid/database/Cursor;", "uri", "Landroid/net/Uri;", "projection", "", "selection", "selectionArgs", "sortOrder", "(Landroid/net/Uri;[Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)Landroid/database/Cursor;", "getFileForUri", "Ljava/io/File;", "getType", "insert", "values", "Landroid/content/ContentValues;", "delete", "", "(Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)I", "update", "(Landroid/net/Uri;Landroid/content/ContentValues;Ljava/lang/String;[Ljava/lang/String;)I", "openFile", "Landroid/os/ParcelFileDescriptor;", "mode", "Companion", "acra-core_release"})
@SourceDebugExtension(value={"SMAP\nAcraContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcraContentProvider.kt\norg/acra/attachment/AcraContentProvider\n+ 2 extensions.kt\norg/acra/log/ExtensionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n7#2,2:222\n7#2,2:224\n7#2,2:229\n37#3,2:226\n1#4:228\n*S KotlinDebug\n*F\n+ 1 AcraContentProvider.kt\norg/acra/attachment/AcraContentProvider\n*L\n48#1:222,2\n64#1:224,2\n145#1:229,2\n77#1:226,2\n*E\n"})
public final class AcraContentProvider
extends ContentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String authority;
    @NotNull
    private static final String[] COLUMNS;
    @NotNull
    private static final String MIME_TYPE_OCTET_STREAM = "application/octet-stream";

    public boolean onCreate() {
        Context context = this.getContext();
        Intrinsics.checkNotNull((Object)context);
        this.authority = AcraContentProvider.Companion.getAuthority(context);
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "Registered content provider for authority " + this.authority;
            aCRALog.d(string, string2);
        }
        return true;
    }

    @Nullable
    public Cursor query(@NotNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Object[] proj = projection;
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "Query: " + uri;
            aCRALog.d(string, string2);
        }
        File file = this.getFileForUri(uri);
        if (file == null) {
            return null;
        }
        File file2 = file;
        if (proj == null) {
            proj = COLUMNS;
        }
        Map columnValueMap = new LinkedHashMap();
        Iterator iterator = ArrayIteratorKt.iterator((Object[])proj);
        while (iterator.hasNext()) {
            String column = (String)iterator.next();
            if (Intrinsics.areEqual((Object)column, (Object)"_display_name")) {
                columnValueMap.put("_display_name", file2.getName());
                continue;
            }
            if (!Intrinsics.areEqual((Object)column, (Object)"_size")) continue;
            columnValueMap.put("_size", file2.length());
        }
        Collection $this$toTypedArray$iv = columnValueMap.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        MatrixCursor cursor = new MatrixCursor(thisCollection$iv.toArray(new String[0]), 1);
        cursor.addRow((Iterable)columnValueMap.values());
        return (Cursor)cursor;
    }

    private final File getFileForUri(Uri uri) {
        File file;
        if (!Intrinsics.areEqual((Object)"content", (Object)uri.getScheme()) || !Intrinsics.areEqual((Object)this.authority, (Object)uri.getAuthority())) {
            return null;
        }
        List list = uri.getPathSegments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPathSegments(...)");
        List segments = CollectionsKt.toMutableList((Collection)list);
        if (segments.size() < 2) {
            return null;
        }
        Object e = segments.remove(0);
        Intrinsics.checkNotNullExpressionValue(e, (String)"removeAt(...)");
        String string = ((String)e).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String dir = string;
        try {
            Directory directory = Directory.valueOf(dir);
            Context context = this.getContext();
            Intrinsics.checkNotNull((Object)context);
            String string2 = TextUtils.join((CharSequence)File.separator, (Iterable)segments);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
            file = directory.getFile(context, string2);
        }
        catch (IllegalArgumentException e2) {
            file = null;
        }
        return file;
    }

    @NotNull
    public String getType(@NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return Companion.guessMimeType(uri);
    }

    @NotNull
    public Uri insert(@NotNull Uri uri, @Nullable ContentValues values) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        throw new UnsupportedOperationException("No insert supported");
    }

    public int delete(@NotNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        throw new UnsupportedOperationException("No delete supported");
    }

    public int update(@NotNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        throw new UnsupportedOperationException("No update supported");
    }

    @NotNull
    public ParcelFileDescriptor openFile(@NotNull Uri uri, @NotNull String mode) throws FileNotFoundException {
        File file;
        block5: {
            block4: {
                File file2;
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
                file = this.getFileForUri(uri);
                if (file == null) break block4;
                File it = file2 = file;
                boolean bl = false;
                file = it.exists() ? file2 : null;
                if (file != null) break block5;
            }
            throw new FileNotFoundException("File represented by uri " + uri + " could not be found");
        }
        File file3 = file;
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = Build.VERSION.SDK_INT >= 19 ? this.getCallingPackage() + " opened " + file3.getPath() : file3.getPath() + " was opened by an application";
            aCRALog.d(string, string2);
        }
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)file3, (int)0x10000000);
        Intrinsics.checkNotNullExpressionValue((Object)parcelFileDescriptor, (String)"open(...)");
        return parcelFileDescriptor;
    }

    @JvmStatic
    @NotNull
    public static final Uri getUriForFile(@NotNull Context context, @NotNull File file) {
        return Companion.getUriForFile(context, file);
    }

    @JvmStatic
    @NotNull
    public static final Uri getUriForFile(@NotNull Context context, @NotNull Directory directory, @NotNull String relativePath) {
        return Companion.getUriForFile(context, directory, relativePath);
    }

    @JvmStatic
    @NotNull
    public static final String guessMimeType(@NotNull Uri uri) {
        return Companion.guessMimeType(uri);
    }

    static {
        String[] stringArray = new String[]{"_display_name", "_size"};
        COLUMNS = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J \u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0007J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\rH\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/acra/attachment/AcraContentProvider$Companion;", "", "<init>", "()V", "COLUMNS", "", "", "[Ljava/lang/String;", "MIME_TYPE_OCTET_STREAM", "getAuthority", "context", "Landroid/content/Context;", "getUriForFile", "Landroid/net/Uri;", "file", "Ljava/io/File;", "directory", "Lorg/acra/file/Directory;", "relativePath", "guessMimeType", "uri", "acra-core_release"})
    @SourceDebugExtension(value={"SMAP\nAcraContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AcraContentProvider.kt\norg/acra/attachment/AcraContentProvider$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,221:1\n37#2,2:222\n*S KotlinDebug\n*F\n+ 1 AcraContentProvider.kt\norg/acra/attachment/AcraContentProvider$Companion\n*L\n193#1:222,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getAuthority(Context context) {
            return context.getPackageName() + ".acra";
        }

        @JvmStatic
        @NotNull
        public final Uri getUriForFile(@NotNull Context context, @NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return this.getUriForFile(context, Directory.ROOT, string);
        }

        @JvmStatic
        @NotNull
        public final Uri getUriForFile(@NotNull Context context, @NotNull Directory directory, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)((Object)directory), (String)"directory");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Uri.Builder builder = new Uri.Builder().scheme("content").authority(this.getAuthority(context));
            String string = directory.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Uri.Builder builder2 = builder.appendPath(string);
            String[] stringArray = new String[]{Pattern.quote(File.separator)};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)relativePath, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            for (String segment : thisCollection$iv.toArray(new String[0])) {
                if (!(((CharSequence)segment).length() > 0)) continue;
                builder2.appendPath(segment);
            }
            Uri uri = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"build(...)");
            return uri;
        }

        @JvmStatic
        @NotNull
        public final String guessMimeType(@NotNull Uri uri) {
            String string;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            String type = null;
            String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            if (fileExtension != null) {
                MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
                String string2 = fileExtension.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                type = mimeTypeMap.getMimeTypeFromExtension(string2);
                if (type == null && Intrinsics.areEqual((Object)"json", (Object)fileExtension)) {
                    type = "application/json";
                }
            }
            if ((string = type) == null) {
                string = AcraContentProvider.MIME_TYPE_OCTET_STREAM;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

