/*
 * Decompiled with CFR 0.152.
 */
package org.acra.interaction;

import android.content.Context;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.acra.ACRA;
import org.acra.config.CoreConfiguration;
import org.acra.interaction.ReportInteraction;
import org.acra.log.ACRALog;
import org.acra.plugins.PluginLoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/acra/interaction/ReportInteractionExecutor;", "", "context", "Landroid/content/Context;", "config", "Lorg/acra/config/CoreConfiguration;", "(Landroid/content/Context;Lorg/acra/config/CoreConfiguration;)V", "reportInteractions", "", "Lorg/acra/interaction/ReportInteraction;", "hasInteractions", "", "performInteractions", "reportFile", "Ljava/io/File;", "acra-core_release"})
@SourceDebugExtension(value={"SMAP\nReportInteractionExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReportInteractionExecutor.kt\norg/acra/interaction/ReportInteractionExecutor\n+ 2 PluginLoader.kt\norg/acra/plugins/PluginLoaderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 extensions.kt\norg/acra/log/ExtensionsKt\n*L\n1#1,62:1\n30#2:63\n1549#3:64\n1620#3,3:65\n19#4,2:68\n7#4,2:70\n*S KotlinDebug\n*F\n+ 1 ReportInteractionExecutor.kt\norg/acra/interaction/ReportInteractionExecutor\n*L\n35#1:63\n40#1:64\n40#1:65,3\n53#1:68,2\n42#1:70,2\n*E\n"})
public final class ReportInteractionExecutor {
    @NotNull
    private final Context context;
    @NotNull
    private final CoreConfiguration config;
    @NotNull
    private final List<ReportInteraction> reportInteractions;

    /*
     * WARNING - void declaration
     */
    public ReportInteractionExecutor(@NotNull Context context, @NotNull CoreConfiguration config) {
        void $this$loadEnabled$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.context = context;
        this.config = config;
        PluginLoader pluginLoader = this.config.getPluginLoader();
        CoreConfiguration config$iv = this.config;
        boolean $i$f$loadEnabled = false;
        this.reportInteractions = $this$loadEnabled$iv.loadEnabled(config$iv, ReportInteraction.class);
    }

    public final boolean hasInteractions() {
        return !((Collection)this.reportInteractions).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean performInteractions(@NotNull File reportFile) {
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)reportFile, (String)"reportFile");
        ExecutorService executorService = Executors.newCachedThreadPool();
        Iterable $this$map$iv = this.reportInteractions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReportInteraction reportInteraction = (ReportInteraction)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(executorService.submit(() -> ReportInteractionExecutor.performInteractions$lambda$2$lambda$1((ReportInteraction)it, this, reportFile)));
        }
        List futures = (List)destination$iv$iv2;
        boolean sendReports = true;
        block4: for (Future future : futures) {
            do {
                try {
                    Object v = future.get();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
                    sendReports &= ((Boolean)v).booleanValue();
                }
                catch (InterruptedException destination$iv$iv2) {
                }
                catch (ExecutionException e) {
                    boolean $i$f$warn = false;
                    String string = ACRA.LOG_TAG;
                    object = ACRA.log;
                    boolean bl = false;
                    String string2 = "Report interaction threw exception, will be ignored.";
                    object.w(string, string2, e);
                    continue block4;
                }
            } while (!future.isDone());
        }
        return sendReports;
    }

    private static final Boolean performInteractions$lambda$2$lambda$1(ReportInteraction $it, ReportInteractionExecutor this$0, File $reportFile) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$reportFile, (String)"$reportFile");
        boolean $i$f$debug = false;
        if (ACRA.DEV_LOGGING) {
            String string = ACRA.LOG_TAG;
            ACRALog aCRALog = ACRA.log;
            boolean bl = false;
            String string2 = "Calling ReportInteraction of class " + $it.getClass().getName();
            aCRALog.d(string, string2);
        }
        return $it.performInteraction(this$0.context, this$0.config, $reportFile);
    }
}

