/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collections;

import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0017\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0011\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0014H\u0096\u0002J\u000b\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u000b\u0010\u0017\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eR\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/acra/collections/WeakStack;", "T", "Ljava/util/AbstractCollection;", "()V", "contents", "", "Ljava/lang/ref/WeakReference;", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "cleanup", "", "clear", "contains", "iterator", "", "peek", "()Ljava/lang/Object;", "pop", "remove", "WeakIterator", "acra-core_release"})
public final class WeakStack<T>
extends AbstractCollection<T> {
    @NotNull
    private final List<WeakReference<T>> contents = new ArrayList();

    private final void cleanup() {
        for (WeakReference<T> weakReference : this.contents) {
            if (weakReference.get() != null) continue;
            this.contents.remove(weakReference);
        }
    }

    public int getSize() {
        this.cleanup();
        return this.contents.size();
    }

    @Override
    public boolean contains(@Nullable Object element) {
        boolean bl;
        block3: {
            Object object = element;
            if (object != null) {
                Object it = object;
                boolean bl2 = false;
                for (WeakReference<T> weakReference : this.contents) {
                    if (!Intrinsics.areEqual((Object)element, weakReference.get())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new WeakIterator<T>(this.contents.iterator());
    }

    @Override
    public boolean add(@Nullable T element) {
        return this.contents.add(new WeakReference<T>(element));
    }

    @Override
    public boolean remove(@Nullable Object element) {
        if (element != null) {
            int n = this.contents.size();
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual((Object)element, this.contents.get(i).get())) continue;
                this.contents.remove(i);
                return true;
            }
        }
        return false;
    }

    public final T peek() {
        int n = this.contents.size() + -1;
        if (0 <= n) {
            do {
                Object result;
                int i = n--;
                Object t = result = this.contents.get(i).get();
                if (t == null) continue;
                return t;
            } while (0 <= n);
        }
        throw new EmptyStackException();
    }

    public final T pop() {
        T result = this.peek();
        this.remove(result);
        return result;
    }

    @Override
    public void clear() {
        this.contents.clear();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0002\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\tH\u0096\u0002J\u000e\u0010\u0006\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00018\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/acra/collections/WeakStack$WeakIterator;", "T", "", "iterator", "Ljava/lang/ref/WeakReference;", "(Ljava/util/Iterator;)V", "next", "Ljava/lang/Object;", "hasNext", "", "()Ljava/lang/Object;", "remove", "", "acra-core_release"})
    private static final class WeakIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        @NotNull
        private final Iterator<WeakReference<T>> iterator;
        @Nullable
        private T next;

        public WeakIterator(@NotNull Iterator<? extends WeakReference<T>> iterator) {
            Intrinsics.checkNotNullParameter(iterator, (String)"iterator");
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.iterator.hasNext()) {
                Object t = this.iterator.next().get();
                if (t == null) continue;
                this.next = t;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            T result = this.next;
            this.next = null;
            while (result == null) {
                result = this.iterator.next().get();
            }
            return result;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

