/*
 * Decompiled with CFR 0.152.
 */
package org.acra.config;

import android.content.Context;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.acra.ACRA;
import org.acra.ACRAConstants;
import org.acra.ReportField;
import org.acra.config.ACRAConfigurationException;
import org.acra.config.Configuration;
import org.acra.config.ConfigurationBuilder;
import org.acra.config.ConfigurationBuilderFactory;
import org.acra.util.StubCreator;

public final class BaseCoreConfigurationBuilder {
    private final Map<ReportField, Boolean> reportContentChanges = new EnumMap<ReportField, Boolean>(ReportField.class);
    private final List<ConfigurationBuilder> configurationBuilders = new ArrayList<ConfigurationBuilder>();
    private List<Configuration> configurations;

    BaseCoreConfigurationBuilder(@NonNull Context app) {
        Iterator<ConfigurationBuilderFactory> iterator = ServiceLoader.load(ConfigurationBuilderFactory.class, this.getClass().getClassLoader()).iterator();
        while (iterator.hasNext()) {
            try {
                ConfigurationBuilderFactory factory = iterator.next();
                if (ACRA.DEV_LOGGING) {
                    ACRA.log.d(ACRA.LOG_TAG, "Discovered and loaded plugin of type " + factory.getClass().getSimpleName().replace("BuilderFactory", ""));
                }
                this.configurationBuilders.add(factory.create(app));
            }
            catch (ServiceConfigurationError e) {
                ACRA.log.e(ACRA.LOG_TAG, "Unable to load ConfigurationBuilderFactory", e);
            }
        }
    }

    void preBuild() throws ACRAConfigurationException {
        this.configurations = new ArrayList<Configuration>();
        for (ConfigurationBuilder builder : this.configurationBuilders) {
            this.configurations.add(builder.build());
        }
    }

    @NonNull
    Set<ReportField> transformReportContent(@NonNull ReportField[] reportFields) {
        LinkedHashSet<ReportField> reportContent = new LinkedHashSet<ReportField>();
        if (reportFields.length != 0) {
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Using custom Report Fields");
            }
            reportContent.addAll(Arrays.asList(reportFields));
        } else {
            if (ACRA.DEV_LOGGING) {
                ACRA.log.d(ACRA.LOG_TAG, "Using default Report Fields");
            }
            reportContent.addAll(Arrays.asList(ACRAConstants.DEFAULT_REPORT_FIELDS));
        }
        for (Map.Entry<ReportField, Boolean> entry : this.reportContentChanges.entrySet()) {
            if (entry.getValue().booleanValue()) {
                reportContent.add(entry.getKey());
                continue;
            }
            reportContent.remove(entry.getKey());
        }
        return reportContent;
    }

    public void setReportField(@NonNull ReportField field, boolean enable) {
        this.reportContentChanges.put(field, enable);
    }

    @NonNull
    List<Configuration> pluginConfigurations() {
        return this.configurations;
    }

    @NonNull
    public <R extends ConfigurationBuilder> R getPluginConfigurationBuilder(@NonNull Class<R> c) {
        for (ConfigurationBuilder builder : this.configurationBuilders) {
            if (!c.isAssignableFrom(builder.getClass())) continue;
            return (R)builder;
        }
        if (c.isInterface()) {
            ACRA.log.w(ACRA.LOG_TAG, "Couldn't find ConfigurationBuilder " + c.getSimpleName() + ". ALL CALLS TO IT WILL BE IGNORED!");
            return (R)((ConfigurationBuilder)StubCreator.createStub(c, (proxy, method, args) -> proxy));
        }
        throw new IllegalArgumentException("Class " + c.getName() + " is not a registered ConfigurationBuilder");
    }
}

