/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.support.annotation.NonNull;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.Collector;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.json.JSONObject;

public final class ThreadCollector
extends BaseReportFieldCollector {
    public ThreadCollector() {
        super(ReportField.THREAD_DETAILS, new ReportField[0]);
    }

    @Override
    @NonNull
    public Collector.Order getOrder() {
        return Collector.Order.LATE;
    }

    @Override
    void collect(@NonNull ReportField reportField, @NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) throws Exception {
        Thread t = reportBuilder.getUncaughtExceptionThread();
        if (t != null) {
            JSONObject result = new JSONObject();
            result.put("id", t.getId());
            result.put("name", (Object)t.getName());
            result.put("priority", t.getPriority());
            if (t.getThreadGroup() != null) {
                result.put("groupName", (Object)t.getThreadGroup().getName());
            }
            target.put(ReportField.THREAD_DETAILS, result);
        } else {
            target.put(ReportField.THREAD_DETAILS, (String)null);
        }
    }
}

