/*
 * Decompiled with CFR 0.152.
 */
package org.acra.collector;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.support.annotation.NonNull;
import org.acra.ReportField;
import org.acra.builder.ReportBuilder;
import org.acra.collector.BaseReportFieldCollector;
import org.acra.collector.CollectorException;
import org.acra.config.CoreConfiguration;
import org.acra.data.CrashReportData;
import org.acra.util.PackageManagerWrapper;

public final class PackageManagerCollector
extends BaseReportFieldCollector {
    public PackageManagerCollector() {
        super(ReportField.APP_VERSION_NAME, ReportField.APP_VERSION_CODE);
    }

    @Override
    void collect(@NonNull ReportField reportField, @NonNull Context context, @NonNull CoreConfiguration config, @NonNull ReportBuilder reportBuilder, @NonNull CrashReportData target) throws CollectorException {
        PackageInfo info = new PackageManagerWrapper(context).getPackageInfo();
        if (info == null) {
            throw new CollectorException("Failed to get package info");
        }
        switch (reportField) {
            case APP_VERSION_NAME: {
                target.put(ReportField.APP_VERSION_NAME, info.versionName);
                break;
            }
            case APP_VERSION_CODE: {
                target.put(ReportField.APP_VERSION_CODE, info.versionCode);
            }
        }
    }
}

