@file:Generated("ch.acanda.gradle.fabrikt.build.GeneratePluginClassesTask")

package ch.acanda.gradle.fabrikt

import javax.`annotation`.processing.Generated
import javax.inject.Inject
import kotlin.Boolean
import kotlin.CharSequence
import kotlin.String
import kotlin.jvm.JvmField
import org.gradle.api.Action
import org.gradle.api.Named
import org.gradle.api.`file`.ConfigurableFileCollection
import org.gradle.api.`file`.DirectoryProperty
import org.gradle.api.`file`.RegularFileProperty
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Input
import org.gradle.api.tasks.InputFile
import org.gradle.api.tasks.InputFiles
import org.gradle.api.tasks.Internal
import org.gradle.api.tasks.Nested
import org.gradle.api.tasks.Optional
import org.gradle.api.tasks.OutputDirectory

public abstract class GenerateTaskConfiguration @Inject constructor(
  private val name: String,
) : Named {
  @get:InputFile
  public abstract val apiFile: RegularFileProperty

  @get:InputFiles
  @get:Optional
  public abstract val apiFragments: ConfigurableFileCollection

  @get:Input
  @get:Optional
  public abstract val externalReferenceResolution: Property<IExternalReferencesResolutionOption>

  @get:Input
  public abstract val basePackage: Property<CharSequence>

  @get:OutputDirectory
  @get:Optional
  public abstract val outputDirectory: DirectoryProperty

  @get:Input
  @get:Optional
  public abstract val sourcesPath: Property<CharSequence>

  @get:Input
  @get:Optional
  public abstract val resourcesPath: Property<CharSequence>

  @get:Input
  @get:Optional
  public abstract val validationLibrary: Property<IValidationLibraryOption>

  @get:Input
  @get:Optional
  public abstract val quarkusReflectionConfig: Property<Boolean>

  @get:Nested
  @get:Optional
  public abstract val typeOverrides: TypeOverridesConfiguration

  @get:Nested
  @get:Optional
  public abstract val client: GenerateClientConfiguration

  @get:Nested
  @get:Optional
  public abstract val controller: GenerateControllerConfiguration

  @get:Nested
  @get:Optional
  public abstract val model: GenerateModelConfiguration

  @get:Input
  @get:Optional
  public abstract val skip: Property<Boolean>

  @JvmField
  public val Jakarta: PolymorphicJakartaOption =
      PolymorphicJakartaOption(ValidationLibraryOption.Jakarta)

  @JvmField
  public val Javax: PolymorphicJavaxOption = PolymorphicJavaxOption(ValidationLibraryOption.Javax)

  @JvmField
  public val NoValidation: PolymorphicNoValidationOption =
      PolymorphicNoValidationOption(ValidationLibraryOption.NoValidation)

  @JvmField
  public val aggressive: PolymorphicAggressiveOption =
      PolymorphicAggressiveOption(ExternalReferencesResolutionOption.aggressive)

  @JvmField
  public val targeted: PolymorphicTargetedOption =
      PolymorphicTargetedOption(ExternalReferencesResolutionOption.targeted)

  @get:Internal
  public val enabled: Boolean = true

  @get:Internal
  public val disabled: Boolean = false

  @Internal
  override fun getName(): String = name

  public fun typeOverrides(action: Action<TypeOverridesConfiguration>) {
    action.execute(typeOverrides)
  }

  public fun client(action: Action<GenerateClientConfiguration>) {
    action.execute(client)
  }

  public fun controller(action: Action<GenerateControllerConfiguration>) {
    action.execute(controller)
  }

  public fun model(action: Action<GenerateModelConfiguration>) {
    action.execute(model)
  }
}

public abstract class TypeOverridesConfiguration {
  @get:Input
  @get:Optional
  public abstract val datetime: Property<IDateTimeOverrideOption>

  @get:Input
  @get:Optional
  public abstract val byte: Property<IByteOverrideOption>

  @get:Input
  @get:Optional
  public abstract val binary: Property<IBinaryOverrideOption>

  @get:Input
  @get:Optional
  public abstract val uri: Property<IUriOverrideOption>

  @get:Input
  @get:Optional
  public abstract val uuid: Property<IUuidOverrideOption>

  @get:Input
  @get:Optional
  public abstract val date: Property<IDateOverrideOption>

  @JvmField
  public val ByteArray: PolymorphicByteArrayOption =
      PolymorphicByteArrayOption(ByteOverrideOption.ByteArray, BinaryOverrideOption.ByteArray)

  @JvmField
  public val InputStream: PolymorphicInputStreamOption =
      PolymorphicInputStreamOption(BinaryOverrideOption.InputStream)

  @JvmField
  public val Instant: PolymorphicInstantOption =
      PolymorphicInstantOption(DateTimeOverrideOption.Instant)

  @JvmField
  public val LocalDate: PolymorphicLocalDateOption =
      PolymorphicLocalDateOption(DateOverrideOption.LocalDate)

  @JvmField
  public val LocalDateTime: PolymorphicLocalDateTimeOption =
      PolymorphicLocalDateTimeOption(DateTimeOverrideOption.LocalDateTime)

  @JvmField
  public val OffsetDateTime: PolymorphicOffsetDateTimeOption =
      PolymorphicOffsetDateTimeOption(DateTimeOverrideOption.OffsetDateTime)

  @JvmField
  public val String: PolymorphicStringOption =
      PolymorphicStringOption(DateTimeOverrideOption.String, ByteOverrideOption.String, BinaryOverrideOption.String, UriOverrideOption.String, UuidOverrideOption.String, DateOverrideOption.String)

  @JvmField
  public val URI: PolymorphicURIOption = PolymorphicURIOption(UriOverrideOption.URI)

  @JvmField
  public val UUID: PolymorphicUUIDOption = PolymorphicUUIDOption(UuidOverrideOption.UUID)
}

public abstract class GenerateClientConfiguration {
  @get:Input
  @get:Optional
  public abstract val generate: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val target: Property<IClientTargetOption>

  @get:Input
  @get:Optional
  public abstract val resilience4j: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val suspendModifier: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val springResponseEntityWrapper: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val springCloudOpenFeignStarterAnnotation: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val openFeignClientName: Property<CharSequence>

  @JvmField
  public val OkHttp: PolymorphicOkHttpOption = PolymorphicOkHttpOption(ClientTargetOption.OkHttp)

  @JvmField
  public val OpenFeign: PolymorphicOpenFeignOption =
      PolymorphicOpenFeignOption(ClientTargetOption.OpenFeign)

  @JvmField
  public val SpringHttpInterface: PolymorphicSpringHttpInterfaceOption =
      PolymorphicSpringHttpInterfaceOption(ClientTargetOption.SpringHttpInterface)

  @get:Internal
  public val enabled: Boolean = true

  @get:Internal
  public val disabled: Boolean = false
}

public abstract class GenerateControllerConfiguration {
  @get:Input
  @get:Optional
  public abstract val generate: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val authentication: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val suspendModifier: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val completionStage: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val target: Property<IControllerTargetOption>

  @JvmField
  public val Ktor: PolymorphicKtorOption = PolymorphicKtorOption(ControllerTargetOption.Ktor)

  @JvmField
  public val Micronaut: PolymorphicMicronautOption =
      PolymorphicMicronautOption(ControllerTargetOption.Micronaut)

  @JvmField
  public val Spring: PolymorphicSpringOption =
      PolymorphicSpringOption(ControllerTargetOption.Spring)

  @get:Internal
  public val enabled: Boolean = true

  @get:Internal
  public val disabled: Boolean = false
}

public abstract class GenerateModelConfiguration {
  @get:Input
  @get:Optional
  public abstract val generate: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val extensibleEnums: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val javaSerialization: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val quarkusReflection: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val micronautIntrospection: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val micronautReflection: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val includeCompanionObject: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val sealedInterfacesForOneOf: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val nonNullMapValues: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val ignoreUnknownProperties: Property<Boolean>

  @get:Input
  @get:Optional
  public abstract val suffix: Property<CharSequence>

  @get:Input
  @get:Optional
  public abstract val serializationLibrary: Property<ISerializationLibraryOption>

  @JvmField
  public val Jackson: PolymorphicJacksonOption =
      PolymorphicJacksonOption(SerializationLibraryOption.Jackson)

  @JvmField
  public val Kotlin: PolymorphicKotlinOption =
      PolymorphicKotlinOption(SerializationLibraryOption.Kotlin)

  @get:Internal
  public val enabled: Boolean = true

  @get:Internal
  public val disabled: Boolean = false
}
