@file:Generated("ch.acanda.gradle.fabrikt.build.GeneratePluginClassesTask")

package ch.acanda.gradle.fabrikt

import com.cjbooms.fabrikt.cli.ClientCodeGenTargetType
import com.cjbooms.fabrikt.cli.CodeGenTypeOverride
import com.cjbooms.fabrikt.cli.ControllerCodeGenTargetType
import com.cjbooms.fabrikt.cli.ExternalReferencesResolutionMode
import com.cjbooms.fabrikt.cli.SerializationLibrary
import com.cjbooms.fabrikt.cli.ValidationLibrary
import java.io.Serializable
import javax.`annotation`.processing.Generated
import kotlin.Enum
import kotlin.String
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName
import kotlin.reflect.KClass
import org.gradle.api.provider.Property

public sealed interface FabriktOption {
  public val fabriktOption: Enum<*>?
}

public enum class ExternalReferencesResolutionOption(
  override val fabriktOption: ExternalReferencesResolutionMode,
) : FabriktOption {
  targeted(ExternalReferencesResolutionMode.TARGETED),
  aggressive(ExternalReferencesResolutionMode.AGGRESSIVE),
  ;
}

public sealed interface IExternalReferencesResolutionOption {
  public fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption

  public companion object {
    public val options: List<IExternalReferencesResolutionOption> =
        listOf(PolymorphicTargetedOption(ExternalReferencesResolutionOption.targeted), PolymorphicAggressiveOption(ExternalReferencesResolutionOption.aggressive))
  }
}

@JvmName("withOptionNameExternalReferencesResolutionOption")
public fun Property<IExternalReferencesResolutionOption>.withOptionName(block: (String) -> Unit) {
  orNull?.let { option -> 
        option.getOptionFor(ExternalReferencesResolutionOption::class).fabriktOption?.name?.let { block(it) }
      }
}

@get:JvmName("optionExternalReferencesResolutionOption")
public val Property<IExternalReferencesResolutionOption>.option: ExternalReferencesResolutionOption?
  get() = orNull?.let { option -> 
    option.getOptionFor(ExternalReferencesResolutionOption::class) as ExternalReferencesResolutionOption
  }

public enum class DateTimeOverrideOption(
  override val fabriktOption: CodeGenTypeOverride?,
) : FabriktOption {
  OffsetDateTime(null),
  Instant(CodeGenTypeOverride.DATETIME_AS_INSTANT),
  LocalDateTime(CodeGenTypeOverride.DATETIME_AS_LOCALDATETIME),
  String(CodeGenTypeOverride.DATETIME_AS_STRING),
  ;
}

public sealed interface IDateTimeOverrideOption {
  public fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption

  public companion object {
    public val options: List<IDateTimeOverrideOption> =
        listOf(PolymorphicOffsetDateTimeOption(DateTimeOverrideOption.OffsetDateTime), PolymorphicInstantOption(DateTimeOverrideOption.Instant), PolymorphicLocalDateTimeOption(DateTimeOverrideOption.LocalDateTime), PolymorphicStringOption(DateTimeOverrideOption.String))
  }
}

@JvmName("withOptionNameDateTimeOverrideOption")
public fun Property<IDateTimeOverrideOption>.withOptionName(block: (String) -> Unit) {
  orNull?.let { option -> 
        option.getOptionFor(DateTimeOverrideOption::class).fabriktOption?.name?.let { block(it) }
      }
}

@get:JvmName("optionDateTimeOverrideOption")
public val Property<IDateTimeOverrideOption>.option: DateTimeOverrideOption?
  get() = orNull?.let { option -> 
    option.getOptionFor(DateTimeOverrideOption::class) as DateTimeOverrideOption
  }

public enum class ByteOverrideOption(
  override val fabriktOption: CodeGenTypeOverride?,
) : FabriktOption {
  ByteArray(null),
  String(CodeGenTypeOverride.BYTE_AS_STRING),
  ;
}

public sealed interface IByteOverrideOption {
  public fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption

  public companion object {
    public val options: List<IByteOverrideOption> =
        listOf(PolymorphicByteArrayOption(ByteOverrideOption.ByteArray), PolymorphicStringOption(ByteOverrideOption.String))
  }
}

@JvmName("withOptionNameByteOverrideOption")
public fun Property<IByteOverrideOption>.withOptionName(block: (String) -> Unit) {
  orNull?.let { option -> 
        option.getOptionFor(ByteOverrideOption::class).fabriktOption?.name?.let { block(it) }
      }
}

@get:JvmName("optionByteOverrideOption")
public val Property<IByteOverrideOption>.option: ByteOverrideOption?
  get() = orNull?.let { option -> 
    option.getOptionFor(ByteOverrideOption::class) as ByteOverrideOption
  }

public enum class BinaryOverrideOption(
  override val fabriktOption: CodeGenTypeOverride?,
) : FabriktOption {
  ByteArray(null),
  InputStream(CodeGenTypeOverride.BYTEARRAY_AS_INPUTSTREAM),
  String(CodeGenTypeOverride.BINARY_AS_STRING),
  ;
}

public sealed interface IBinaryOverrideOption {
  public fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption

  public companion object {
    public val options: List<IBinaryOverrideOption> =
        listOf(PolymorphicByteArrayOption(BinaryOverrideOption.ByteArray), PolymorphicInputStreamOption(BinaryOverrideOption.InputStream), PolymorphicStringOption(BinaryOverrideOption.String))
  }
}

@JvmName("withOptionNameBinaryOverrideOption")
public fun Property<IBinaryOverrideOption>.withOptionName(block: (String) -> Unit) {
  orNull?.let { option -> 
        option.getOptionFor(BinaryOverrideOption::class).fabriktOption?.name?.let { block(it) }
      }
}

@get:JvmName("optionBinaryOverrideOption")
public val Property<IBinaryOverrideOption>.option: BinaryOverrideOption?
  get() = orNull?.let { option -> 
    option.getOptionFor(BinaryOverrideOption::class) as BinaryOverrideOption
  }

public enum class UriOverrideOption(
  override val fabriktOption: CodeGenTypeOverride?,
) : FabriktOption {
  URI(null),
  String(CodeGenTypeOverride.URI_AS_STRING),
  ;
}

public sealed interface IUriOverrideOption {
  public fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption

  public companion object {
    public val options: List<IUriOverrideOption> =
        listOf(PolymorphicURIOption(UriOverrideOption.URI), PolymorphicStringOption(UriOverrideOption.String))
  }
}

@JvmName("withOptionNameUriOverrideOption")
public fun Property<IUriOverrideOption>.withOptionName(block: (String) -> Unit) {
  orNull?.let { option -> 
        option.getOptionFor(UriOverrideOption::class).fabriktOption?.name?.let { block(it) }
      }
}

@get:JvmName("optionUriOverrideOption")
public val Property<IUriOverrideOption>.option: UriOverrideOption?
  get() = orNull?.let { option -> 
    option.getOptionFor(UriOverrideOption::class) as UriOverrideOption
  }

public enum class UuidOverrideOption(
  override val fabriktOption: CodeGenTypeOverride?,
) : FabriktOption {
  UUID(null),
  String(CodeGenTypeOverride.UUID_AS_STRING),
  ;
}

public sealed interface IUuidOverrideOption {
  public fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption

  public companion object {
    public val options: List<IUuidOverrideOption> =
        listOf(PolymorphicUUIDOption(UuidOverrideOption.UUID), PolymorphicStringOption(UuidOverrideOption.String))
  }
}

@JvmName("withOptionNameUuidOverrideOption")
public fun Property<IUuidOverrideOption>.withOptionName(block: (String) -> Unit) {
  orNull?.let { option -> 
        option.getOptionFor(UuidOverrideOption::class).fabriktOption?.name?.let { block(it) }
      }
}

@get:JvmName("optionUuidOverrideOption")
public val Property<IUuidOverrideOption>.option: UuidOverrideOption?
  get() = orNull?.let { option -> 
    option.getOptionFor(UuidOverrideOption::class) as UuidOverrideOption
  }

public enum class DateOverrideOption(
  override val fabriktOption: CodeGenTypeOverride?,
) : FabriktOption {
  LocalDate(null),
  String(CodeGenTypeOverride.DATE_AS_STRING),
  ;
}

public sealed interface IDateOverrideOption {
  public fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption

  public companion object {
    public val options: List<IDateOverrideOption> =
        listOf(PolymorphicLocalDateOption(DateOverrideOption.LocalDate), PolymorphicStringOption(DateOverrideOption.String))
  }
}

@JvmName("withOptionNameDateOverrideOption")
public fun Property<IDateOverrideOption>.withOptionName(block: (String) -> Unit) {
  orNull?.let { option -> 
        option.getOptionFor(DateOverrideOption::class).fabriktOption?.name?.let { block(it) }
      }
}

@get:JvmName("optionDateOverrideOption")
public val Property<IDateOverrideOption>.option: DateOverrideOption?
  get() = orNull?.let { option -> 
    option.getOptionFor(DateOverrideOption::class) as DateOverrideOption
  }

public enum class ValidationLibraryOption(
  override val fabriktOption: ValidationLibrary,
) : FabriktOption {
  Jakarta(ValidationLibrary.JAKARTA_VALIDATION),
  Javax(ValidationLibrary.JAVAX_VALIDATION),
  NoValidation(ValidationLibrary.NO_VALIDATION),
  ;
}

public sealed interface IValidationLibraryOption {
  public fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption

  public companion object {
    public val options: List<IValidationLibraryOption> =
        listOf(PolymorphicJakartaOption(ValidationLibraryOption.Jakarta), PolymorphicJavaxOption(ValidationLibraryOption.Javax), PolymorphicNoValidationOption(ValidationLibraryOption.NoValidation))
  }
}

@JvmName("withOptionNameValidationLibraryOption")
public fun Property<IValidationLibraryOption>.withOptionName(block: (String) -> Unit) {
  orNull?.let { option -> 
        option.getOptionFor(ValidationLibraryOption::class).fabriktOption?.name?.let { block(it) }
      }
}

@get:JvmName("optionValidationLibraryOption")
public val Property<IValidationLibraryOption>.option: ValidationLibraryOption?
  get() = orNull?.let { option -> 
    option.getOptionFor(ValidationLibraryOption::class) as ValidationLibraryOption
  }

public enum class ClientTargetOption(
  override val fabriktOption: ClientCodeGenTargetType,
) : FabriktOption {
  OkHttp(ClientCodeGenTargetType.OK_HTTP),
  OpenFeign(ClientCodeGenTargetType.OPEN_FEIGN),
  SpringHttpInterface(ClientCodeGenTargetType.SPRING_HTTP_INTERFACE),
  ;
}

public sealed interface IClientTargetOption {
  public fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption

  public companion object {
    public val options: List<IClientTargetOption> =
        listOf(PolymorphicOkHttpOption(ClientTargetOption.OkHttp), PolymorphicOpenFeignOption(ClientTargetOption.OpenFeign), PolymorphicSpringHttpInterfaceOption(ClientTargetOption.SpringHttpInterface))
  }
}

@JvmName("withOptionNameClientTargetOption")
public fun Property<IClientTargetOption>.withOptionName(block: (String) -> Unit) {
  orNull?.let { option -> 
        option.getOptionFor(ClientTargetOption::class).fabriktOption?.name?.let { block(it) }
      }
}

@get:JvmName("optionClientTargetOption")
public val Property<IClientTargetOption>.option: ClientTargetOption?
  get() = orNull?.let { option -> 
    option.getOptionFor(ClientTargetOption::class) as ClientTargetOption
  }

public enum class ControllerTargetOption(
  override val fabriktOption: ControllerCodeGenTargetType,
) : FabriktOption {
  Spring(ControllerCodeGenTargetType.SPRING),
  Micronaut(ControllerCodeGenTargetType.MICRONAUT),
  Ktor(ControllerCodeGenTargetType.KTOR),
  ;
}

public sealed interface IControllerTargetOption {
  public fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption

  public companion object {
    public val options: List<IControllerTargetOption> =
        listOf(PolymorphicSpringOption(ControllerTargetOption.Spring), PolymorphicMicronautOption(ControllerTargetOption.Micronaut), PolymorphicKtorOption(ControllerTargetOption.Ktor))
  }
}

@JvmName("withOptionNameControllerTargetOption")
public fun Property<IControllerTargetOption>.withOptionName(block: (String) -> Unit) {
  orNull?.let { option -> 
        option.getOptionFor(ControllerTargetOption::class).fabriktOption?.name?.let { block(it) }
      }
}

@get:JvmName("optionControllerTargetOption")
public val Property<IControllerTargetOption>.option: ControllerTargetOption?
  get() = orNull?.let { option -> 
    option.getOptionFor(ControllerTargetOption::class) as ControllerTargetOption
  }

public enum class SerializationLibraryOption(
  override val fabriktOption: SerializationLibrary,
) : FabriktOption {
  Jackson(SerializationLibrary.JACKSON),
  Kotlin(SerializationLibrary.KOTLINX_SERIALIZATION),
  ;
}

public sealed interface ISerializationLibraryOption {
  public fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption

  public companion object {
    public val options: List<ISerializationLibraryOption> =
        listOf(PolymorphicJacksonOption(SerializationLibraryOption.Jackson), PolymorphicKotlinOption(SerializationLibraryOption.Kotlin))
  }
}

@JvmName("withOptionNameSerializationLibraryOption")
public fun Property<ISerializationLibraryOption>.withOptionName(block: (String) -> Unit) {
  orNull?.let { option -> 
        option.getOptionFor(SerializationLibraryOption::class).fabriktOption?.name?.let { block(it) }
      }
}

@get:JvmName("optionSerializationLibraryOption")
public val Property<ISerializationLibraryOption>.option: SerializationLibraryOption?
  get() = orNull?.let { option -> 
    option.getOptionFor(SerializationLibraryOption::class) as SerializationLibraryOption
  }

public class PolymorphicByteArrayOption(
  vararg options: FabriktOption,
) : Serializable,
    IByteOverrideOption,
    IBinaryOverrideOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicInputStreamOption(
  vararg options: FabriktOption,
) : Serializable,
    IBinaryOverrideOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicInstantOption(
  vararg options: FabriktOption,
) : Serializable,
    IDateTimeOverrideOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicJacksonOption(
  vararg options: FabriktOption,
) : Serializable,
    ISerializationLibraryOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicJakartaOption(
  vararg options: FabriktOption,
) : Serializable,
    IValidationLibraryOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicJavaxOption(
  vararg options: FabriktOption,
) : Serializable,
    IValidationLibraryOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicKotlinOption(
  vararg options: FabriktOption,
) : Serializable,
    ISerializationLibraryOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicKtorOption(
  vararg options: FabriktOption,
) : Serializable,
    IControllerTargetOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicLocalDateOption(
  vararg options: FabriktOption,
) : Serializable,
    IDateOverrideOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicLocalDateTimeOption(
  vararg options: FabriktOption,
) : Serializable,
    IDateTimeOverrideOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicMicronautOption(
  vararg options: FabriktOption,
) : Serializable,
    IControllerTargetOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicNoValidationOption(
  vararg options: FabriktOption,
) : Serializable,
    IValidationLibraryOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicOffsetDateTimeOption(
  vararg options: FabriktOption,
) : Serializable,
    IDateTimeOverrideOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicOkHttpOption(
  vararg options: FabriktOption,
) : Serializable,
    IClientTargetOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicOpenFeignOption(
  vararg options: FabriktOption,
) : Serializable,
    IClientTargetOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicSpringOption(
  vararg options: FabriktOption,
) : Serializable,
    IControllerTargetOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicSpringHttpInterfaceOption(
  vararg options: FabriktOption,
) : Serializable,
    IClientTargetOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicStringOption(
  vararg options: FabriktOption,
) : Serializable,
    IDateTimeOverrideOption,
    IByteOverrideOption,
    IBinaryOverrideOption,
    IUriOverrideOption,
    IUuidOverrideOption,
    IDateOverrideOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicURIOption(
  vararg options: FabriktOption,
) : Serializable,
    IUriOverrideOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicUUIDOption(
  vararg options: FabriktOption,
) : Serializable,
    IUuidOverrideOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicAggressiveOption(
  vararg options: FabriktOption,
) : Serializable,
    IExternalReferencesResolutionOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}

public class PolymorphicTargetedOption(
  vararg options: FabriktOption,
) : Serializable,
    IExternalReferencesResolutionOption {
  public val options: List<FabriktOption> = listOf(*options)

  override fun getOptionFor(type: KClass<out FabriktOption>): FabriktOption = options.first { it::class == type }
}
