@file:Generated("ch.acanda.gradle.fabrikt.build.GeneratePluginClassesTask")

package ch.acanda.gradle.fabrikt

import javax.`annotation`.processing.Generated
import javax.inject.Inject
import kotlin.Boolean
import kotlin.CharSequence
import kotlin.jvm.JvmField
import org.gradle.api.Action
import org.gradle.api.Named
import org.gradle.api.`file`.ConfigurableFileCollection
import org.gradle.api.`file`.DirectoryProperty
import org.gradle.api.`file`.RegularFileProperty
import org.gradle.api.provider.Property
import org.gradle.api.tasks.Nested

public abstract class GenerateTaskExtension @Inject constructor() : Named {
  public abstract val apiFile: RegularFileProperty

  public abstract val apiFragments: ConfigurableFileCollection

  public abstract val externalReferenceResolution: Property<IExternalReferencesResolutionOption>

  public abstract val basePackage: Property<CharSequence>

  public abstract val outputDirectory: DirectoryProperty

  public abstract val sourcesPath: Property<CharSequence>

  public abstract val resourcesPath: Property<CharSequence>

  public abstract val validationLibrary: Property<IValidationLibraryOption>

  public abstract val quarkusReflectionConfig: Property<Boolean>

  @get:Nested
  public abstract val typeOverrides: TypeOverridesExtension

  @get:Nested
  public abstract val client: GenerateClientExtension

  @get:Nested
  public abstract val controller: GenerateControllerExtension

  @get:Nested
  public abstract val model: GenerateModelExtension

  public abstract val skip: Property<Boolean>

  @JvmField
  public val Jakarta: PolymorphicJakartaOption =
      PolymorphicJakartaOption(ValidationLibraryOption.Jakarta)

  @JvmField
  public val Javax: PolymorphicJavaxOption = PolymorphicJavaxOption(ValidationLibraryOption.Javax)

  @JvmField
  public val NoValidation: PolymorphicNoValidationOption =
      PolymorphicNoValidationOption(ValidationLibraryOption.NoValidation)

  @JvmField
  public val aggressive: PolymorphicAggressiveOption =
      PolymorphicAggressiveOption(ExternalReferencesResolutionOption.aggressive)

  @JvmField
  public val targeted: PolymorphicTargetedOption =
      PolymorphicTargetedOption(ExternalReferencesResolutionOption.targeted)

  @JvmField
  public val enabled: Boolean = true

  @JvmField
  public val disabled: Boolean = false

  public fun typeOverrides(action: Action<TypeOverridesExtension>) {
    action.execute(typeOverrides)
  }

  public fun client(action: Action<GenerateClientExtension>) {
    action.execute(client)
  }

  public fun controller(action: Action<GenerateControllerExtension>) {
    action.execute(controller)
  }

  public fun model(action: Action<GenerateModelExtension>) {
    action.execute(model)
  }
}

public abstract class TypeOverridesExtension {
  public abstract val datetime: Property<IDateTimeOverrideOption>

  public abstract val byte: Property<IByteOverrideOption>

  public abstract val binary: Property<IBinaryOverrideOption>

  public abstract val uri: Property<IUriOverrideOption>

  public abstract val uuid: Property<IUuidOverrideOption>

  public abstract val date: Property<IDateOverrideOption>

  @JvmField
  public val ByteArray: PolymorphicByteArrayOption =
      PolymorphicByteArrayOption(ByteOverrideOption.ByteArray, BinaryOverrideOption.ByteArray)

  @JvmField
  public val InputStream: PolymorphicInputStreamOption =
      PolymorphicInputStreamOption(BinaryOverrideOption.InputStream)

  @JvmField
  public val Instant: PolymorphicInstantOption =
      PolymorphicInstantOption(DateTimeOverrideOption.Instant)

  @JvmField
  public val LocalDate: PolymorphicLocalDateOption =
      PolymorphicLocalDateOption(DateOverrideOption.LocalDate)

  @JvmField
  public val LocalDateTime: PolymorphicLocalDateTimeOption =
      PolymorphicLocalDateTimeOption(DateTimeOverrideOption.LocalDateTime)

  @JvmField
  public val OffsetDateTime: PolymorphicOffsetDateTimeOption =
      PolymorphicOffsetDateTimeOption(DateTimeOverrideOption.OffsetDateTime)

  @JvmField
  public val String: PolymorphicStringOption =
      PolymorphicStringOption(DateTimeOverrideOption.String, ByteOverrideOption.String, BinaryOverrideOption.String, UriOverrideOption.String, UuidOverrideOption.String, DateOverrideOption.String)

  @JvmField
  public val URI: PolymorphicURIOption = PolymorphicURIOption(UriOverrideOption.URI)

  @JvmField
  public val UUID: PolymorphicUUIDOption = PolymorphicUUIDOption(UuidOverrideOption.UUID)
}

public abstract class GenerateClientExtension {
  public abstract val generate: Property<Boolean>

  public abstract val target: Property<IClientTargetOption>

  public abstract val resilience4j: Property<Boolean>

  public abstract val suspendModifier: Property<Boolean>

  public abstract val springResponseEntityWrapper: Property<Boolean>

  public abstract val springCloudOpenFeignStarterAnnotation: Property<Boolean>

  public abstract val openFeignClientName: Property<CharSequence>

  @JvmField
  public val OkHttp: PolymorphicOkHttpOption = PolymorphicOkHttpOption(ClientTargetOption.OkHttp)

  @JvmField
  public val OpenFeign: PolymorphicOpenFeignOption =
      PolymorphicOpenFeignOption(ClientTargetOption.OpenFeign)

  @JvmField
  public val SpringHttpInterface: PolymorphicSpringHttpInterfaceOption =
      PolymorphicSpringHttpInterfaceOption(ClientTargetOption.SpringHttpInterface)

  @JvmField
  public val enabled: Boolean = true

  @JvmField
  public val disabled: Boolean = false
}

public abstract class GenerateControllerExtension {
  public abstract val generate: Property<Boolean>

  public abstract val authentication: Property<Boolean>

  public abstract val suspendModifier: Property<Boolean>

  public abstract val completionStage: Property<Boolean>

  public abstract val target: Property<IControllerTargetOption>

  @JvmField
  public val Ktor: PolymorphicKtorOption = PolymorphicKtorOption(ControllerTargetOption.Ktor)

  @JvmField
  public val Micronaut: PolymorphicMicronautOption =
      PolymorphicMicronautOption(ControllerTargetOption.Micronaut)

  @JvmField
  public val Spring: PolymorphicSpringOption =
      PolymorphicSpringOption(ControllerTargetOption.Spring)

  @JvmField
  public val enabled: Boolean = true

  @JvmField
  public val disabled: Boolean = false
}

public abstract class GenerateModelExtension {
  public abstract val generate: Property<Boolean>

  public abstract val extensibleEnums: Property<Boolean>

  public abstract val javaSerialization: Property<Boolean>

  public abstract val quarkusReflection: Property<Boolean>

  public abstract val micronautIntrospection: Property<Boolean>

  public abstract val micronautReflection: Property<Boolean>

  public abstract val includeCompanionObject: Property<Boolean>

  public abstract val sealedInterfacesForOneOf: Property<Boolean>

  public abstract val nonNullMapValues: Property<Boolean>

  public abstract val ignoreUnknownProperties: Property<Boolean>

  public abstract val suffix: Property<CharSequence>

  public abstract val serializationLibrary: Property<ISerializationLibraryOption>

  @JvmField
  public val Jackson: PolymorphicJacksonOption =
      PolymorphicJacksonOption(SerializationLibraryOption.Jackson)

  @JvmField
  public val Kotlin: PolymorphicKotlinOption =
      PolymorphicKotlinOption(SerializationLibraryOption.Kotlin)

  @JvmField
  public val enabled: Boolean = true

  @JvmField
  public val disabled: Boolean = false
}
