/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.logging;

import cd.connect.context.ConnectContext;
import cd.connect.jersey.common.logging.JerseyFiltering;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.logging.BaseFilteringLogger;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.message.MessageUtils;

@ConstrainedTo(value=RuntimeType.SERVER)
@Priority(value=0x7FFFFFFF)
public class FilteringServerLoggingFilter
extends BaseFilteringLogger
implements ContainerRequestFilter,
ContainerResponseFilter {
    public FilteringServerLoggingFilter(JerseyFiltering jerseyFiltering) {
        super(jerseyFiltering, LoggingFeature.Verbosity.PAYLOAD_ANY);
    }

    protected void recordIncoming(ContainerRequestContext context, String action) {
        ConnectContext.set((String)"connect.rest.method", (Object)(action + ": " + context.getMethod() + " - " + context.getUriInfo().getRequestUri().toASCIIString()));
    }

    public void filter(ContainerRequestContext context) throws IOException {
        String uri = context.getUriInfo().getRequestUri().getPath();
        if (this.jerseyFiltering.excludeForUri(uri)) {
            return;
        }
        long id = this._id.incrementAndGet();
        context.setProperty(LOGGING_ID_PROPERTY, (Object)id);
        this.recordIncoming(context, "received");
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, "Server has received a request", id, context.getMethod(), context.getUriInfo().getRequestUri());
        this.printPrefixedHeaders(b, id, "> ", (MultivaluedMap<String, String>)context.getHeaders());
        if (context.hasEntity() && FilteringServerLoggingFilter.printEntity(this.verbosity, context.getMediaType()) && !this.jerseyFiltering.excludePayloadForUri(uri)) {
            context.setEntityStream(this.logInboundEntity(b, context.getEntityStream(), MessageUtils.getCharset((MediaType)context.getMediaType())));
        }
        this.log(b);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        String uri = requestContext.getUriInfo().getRequestUri().getPath();
        if (this.jerseyFiltering.excludeForUri(uri)) {
            return;
        }
        this.recordIncoming(requestContext, "responded");
        ConnectContext.set((String)"connect.response.statusCode", (Object)Integer.toString(responseContext.getStatus()));
        Object requestId = requestContext.getProperty(LOGGING_ID_PROPERTY);
        long id = requestId != null ? ((Long)requestId).longValue() : this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Server responded with a response", id, responseContext.getStatus());
        this.printPrefixedHeaders(b, id, "< ", (MultivaluedMap<String, String>)responseContext.getStringHeaders());
        if (responseContext.hasEntity() && FilteringServerLoggingFilter.printEntity(this.verbosity, responseContext.getMediaType())) {
            BaseFilteringLogger.LoggingStream stream = new BaseFilteringLogger.LoggingStream(b, responseContext.getEntityStream());
            responseContext.setEntityStream((OutputStream)stream);
            requestContext.setProperty(ENTITY_LOGGER_PROPERTY, (Object)stream);
        } else {
            this.log(b);
        }
    }
}

