/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.logging;

import cd.connect.context.ConnectContext;
import cd.connect.jersey.common.logging.JerseyFiltering;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import javax.annotation.Priority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.logging.BaseFilteringLogger;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.message.MessageUtils;

@ConstrainedTo(value=RuntimeType.CLIENT)
@Priority(value=0x7FFFFFFF)
public class FilteringClientLoggingFilter
extends BaseFilteringLogger
implements ClientRequestFilter,
ClientResponseFilter {
    public FilteringClientLoggingFilter(JerseyFiltering jerseyFiltering) {
        super(jerseyFiltering, LoggingFeature.Verbosity.PAYLOAD_ANY);
    }

    protected void recordOutgoing(ClientRequestContext context, String action) {
        ConnectContext.set((String)"connect.rest.method", (Object)(action + ": " + context.getMethod() + " - " + context.getMethod() + " " + context.getUri().toASCIIString()));
    }

    public void filter(ClientRequestContext context) throws IOException {
        String uriPath = context.getUri().getPath();
        if (!this.logger.isTraceEnabled() || this.jerseyFiltering.excludeForUri(uriPath)) {
            return;
        }
        long id = this._id.incrementAndGet();
        context.setProperty(LOGGING_ID_PROPERTY, (Object)id);
        context.setProperty("connect.response.ms", (Object)System.currentTimeMillis());
        StringBuilder b = new StringBuilder();
        URI uri = context.getUri();
        this.recordOutgoing(context, "sending");
        this.printRequestLine(b, "Sending client request", id, context.getMethod(), uri);
        this.printPrefixedHeaders(b, id, "> ", (MultivaluedMap<String, String>)context.getStringHeaders());
        if (context.hasEntity() && FilteringClientLoggingFilter.printEntity(this.verbosity, context.getMediaType()) && !this.jerseyFiltering.excludePayloadForUri(uriPath)) {
            BaseFilteringLogger.LoggingStream stream = new BaseFilteringLogger.LoggingStream(b, context.getEntityStream());
            context.setEntityStream((OutputStream)stream);
            context.setProperty(ENTITY_LOGGER_PROPERTY, (Object)stream);
        } else {
            this.log(b);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        Object originalStart;
        String uriPath = requestContext.getUri().getPath();
        if (!this.logger.isTraceEnabled() || this.jerseyFiltering.excludeForUri(uriPath)) {
            return;
        }
        this.recordOutgoing(requestContext, "response");
        Object requestId = requestContext.getProperty(LOGGING_ID_PROPERTY);
        long id = requestId != null ? ((Long)requestId).longValue() : this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Client response received", id, responseContext.getStatus());
        this.printPrefixedHeaders(b, id, "< ", (MultivaluedMap<String, String>)responseContext.getHeaders());
        if (responseContext.hasEntity() && FilteringClientLoggingFilter.printEntity(this.verbosity, responseContext.getMediaType())) {
            responseContext.setEntityStream(this.logInboundEntity(b, responseContext.getEntityStream(), MessageUtils.getCharset((MediaType)responseContext.getMediaType())));
        }
        if ((originalStart = requestContext.getProperty("connect.response.ms")) != null) {
            if (originalStart instanceof String) {
                requestContext.removeProperty("connect.response.ms");
            } else {
                Long start = (Long)originalStart;
                long end = System.currentTimeMillis();
                ConnectContext.set((String)"connect.response.ms", (Object)(end - start + ""));
            }
        }
        this.log(b);
    }
}

