/*
 * Decompiled with CFR 0.152.
 */
package jsonij.jpath.predicate;

import java.util.List;
import jsonij.Value;
import jsonij.jpath.PredicateComponent;

public class LastIndexPredicate
extends PredicateComponent {
    int offset;
    public static final LastIndexPredicate LAST = new LastIndexPredicate();

    public LastIndexPredicate() {
        this(0);
    }

    public LastIndexPredicate(int offset) {
        this.offset = Math.abs(offset);
    }

    public boolean hasOffset() {
        return this.offset != 0;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LastIndexPredicate other = (LastIndexPredicate)obj;
        return this.offset == other.offset;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.offset;
        return hash;
    }

    @Override
    public List<Value> evaluate(List<Value> values, List<Value> results) {
        if (!this.hasOffset()) {
            int indexPredicate = -1;
            for (Value value : values) {
                indexPredicate = value.size() - 1;
                if (indexPredicate < 0) continue;
                results.add(value.get(indexPredicate));
            }
        } else {
            int indexPredicate = -1;
            for (Value value : values) {
                indexPredicate = value.size() - this.getOffset();
                if (indexPredicate < 0) continue;
                results.add(value.get(indexPredicate));
            }
        }
        return results;
    }
}

