/*
 * Decompiled with CFR 0.152.
 */
package jsonij.jpath.predicate;

import java.util.ArrayList;
import jsonij.Value;
import jsonij.jpath.JPathParserException;
import jsonij.parser.JSONParser;
import jsonij.parser.ParserException;
import jsonij.parser.StringJSONReader;

public class FunctionArgument {
    ARGUMENT_TYPE type;

    public ARGUMENT_TYPE getType() {
        return this.type;
    }

    public void setType(ARGUMENT_TYPE type) {
        this.type = type;
    }

    public static FunctionArgument[] parseStringToArguments(String string) throws JPathParserException {
        FunctionArgument[] argumentArray = null;
        ArrayList<FunctionArgument> argumentList = new ArrayList<FunctionArgument>();
        int stringLength = string.length();
        int i = 0;
        while (i < stringLength - 1) {
            char c = string.charAt(i);
            while (i < stringLength - 1 && c == ' ') {
                c = string.charAt(++i);
            }
            if (c == '@') {
                if (i < stringLength - 1) {
                    c = string.charAt(++i);
                }
                if (c == '.') {
                    StringBuilder attributebuilder = new StringBuilder();
                    if (i < stringLength - 1) {
                        c = string.charAt(++i);
                    }
                    while (c != ',') {
                        attributebuilder.append(c);
                        if (i >= stringLength - 1) break;
                        c = string.charAt(++i);
                    }
                    if (i >= stringLength - 1) break;
                    c = string.charAt(++i);
                    AttributeArgument argument = new AttributeArgument(attributebuilder.toString().trim());
                    argumentList.add(argument);
                    continue;
                }
                throw new JPathParserException("functionPredicateAttributeParse", 0, 0, new Object[]{Character.valueOf('.')});
            }
            try {
                StringJSONReader targetReader = new StringJSONReader(string, i);
                JSONParser valueParser = new JSONParser(targetReader);
                Value value = valueParser.parseValue();
                i = targetReader.getIndex();
                ValueArgument argument = new ValueArgument(value);
                argumentList.add(argument);
            }
            catch (ParserException ex) {
                throw new JPathParserException("functionPredicateValueParse", 0, 0, new Object[]{ex});
            }
        }
        argumentArray = new FunctionArgument[argumentList.size()];
        argumentList.toArray(argumentArray);
        return argumentArray;
    }

    public static class ValueArgument
    extends FunctionArgument {
        Value value;

        public ValueArgument(Value value) {
            this.value = value;
            this.type = ARGUMENT_TYPE.VALUE;
        }

        public Value getValue() {
            return this.value;
        }

        public void setValue(Value value) {
            this.value = value;
        }

        public String toString() {
            return this.value.toJSON();
        }
    }

    public static class AttributeArgument
    extends FunctionArgument {
        String attributeName;

        public AttributeArgument(String attributeName) {
            this.attributeName = attributeName;
            this.type = ARGUMENT_TYPE.ATTRIBUTE;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public String toString() {
            return String.format("@.%s", this.attributeName);
        }
    }

    public static enum ARGUMENT_TYPE {
        ATTRIBUTE,
        VALUE;

    }
}

