/*
 * Decompiled with CFR 0.152.
 */
package jsonij.jpath;

import java.util.List;
import jsonij.Value;
import jsonij.ValueType;
import jsonij.jpath.Component;

public class KeyComponent
extends Component {
    private String value;
    private int size;

    public KeyComponent(String value) {
        this.value = value;
        this.size = value.length();
    }

    public KeyComponent(String value, int size) {
        this.value = value;
        this.size = size;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.size = value.length();
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return String.format("KeyComponent [%s]", this.value);
    }

    @Override
    public List<Value> evaluate(List<Value> values, List<Value> results) {
        Value valueStore = null;
        for (Value currentValue : values) {
            String keyValue = this.getValue();
            if (currentValue.getValueType() == ValueType.OBJECT) {
                valueStore = currentValue.get(keyValue);
                if (valueStore == null) continue;
                results.add(valueStore);
                continue;
            }
            if (currentValue.getValueType() != ValueType.ARRAY) continue;
            for (int j = 0; j < currentValue.size(); ++j) {
                valueStore = currentValue.get(j).get(keyValue);
                if (valueStore == null) continue;
                results.add(valueStore);
            }
        }
        return results;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyComponent other = (KeyComponent)obj;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }
}

