/*
 * Decompiled with CFR 0.152.
 */
package jsonij.jpath;

import jsonij.ConstantUtility;
import jsonij.Value;
import jsonij.jpath.AllComponent;
import jsonij.jpath.Component;
import jsonij.jpath.JPath;
import jsonij.jpath.JPathParserException;
import jsonij.jpath.JPathReader;
import jsonij.jpath.KeyComponent;
import jsonij.jpath.PredicateComponent;
import jsonij.jpath.SearchComponent;
import jsonij.jpath.predicate.AllPredicate;
import jsonij.jpath.predicate.ExpressionPredicate;
import jsonij.jpath.predicate.FunctionArgument;
import jsonij.jpath.predicate.LastIndexPredicate;
import jsonij.jpath.predicate.SimpleIndexPredicate;
import jsonij.jpath.predicate.StartEndStepPredicate;
import jsonij.jpath.predicate.UnionPredicate;
import jsonij.parser.JSONParser;
import jsonij.parser.ParserException;

public class JPathParser {
    public JPath<Component> parse(String jPath) throws ParserException {
        JPathReader target = new JPathReader(jPath);
        return this.parse(target);
    }

    public JPath<Component> parse(JPathReader target) throws ParserException {
        JPath<Component> path = new JPath<Component>();
        JPathMode mode = null;
        if (mode == null) {
            if (target.peek() == 47) {
                mode = JPathMode.SOLIDUS;
            } else if (target.peek() == 36) {
                mode = JPathMode.PERIOD;
            }
        }
        while (target.peek() != -1) {
            KeyComponent key;
            if (mode == JPathMode.SOLIDUS && target.peek() == 47) {
                target.read();
                if (target.peek() != 47) continue;
                target.read();
                path.add(new SearchComponent());
                continue;
            }
            if (mode == JPathMode.PERIOD && target.peek() == 46) {
                target.read();
                if (target.peek() != 46) continue;
                target.read();
                path.add(new SearchComponent());
                continue;
            }
            if (mode == JPathMode.PERIOD && target.peek() == 36) {
                target.read();
                if (target.peek() == 46) {
                    target.read();
                    if (target.peek() != 46) continue;
                    target.read();
                    path.add(new SearchComponent());
                    continue;
                }
                if (target.peek() != 91) continue;
                mode = JPathMode.PATH;
                continue;
            }
            if (mode == JPathMode.PATH && target.peek() == 91) {
                target.read();
                if (target.peek() == 39) {
                    target.read();
                    key = this.readKey(target, JPathMode.PATH);
                    if (key == null) {
                        throw new JPathParserException("invalidKey", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)target.peek())});
                    }
                    path.add(key);
                    if (target.peek() == 39) {
                        target.read();
                        if (target.peek() == 93) {
                            target.read();
                            continue;
                        }
                        throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
                    }
                    throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('\''), Character.valueOf((char)target.peek())});
                }
                throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('\''), Character.valueOf((char)target.peek())});
            }
            if (target.peek() == 91) {
                PredicateComponent predicate = this.readPredicate(target, mode);
                if (predicate == null) continue;
                path.add(predicate);
                continue;
            }
            if (target.peek() == 42) {
                target.read();
                path.add(new AllComponent());
                continue;
            }
            key = this.readKey(target, mode);
            if (key == null) continue;
            path.add(key);
        }
        return path;
    }

    public KeyComponent readKey(JPathReader target, JPathMode mode) throws ParserException {
        StringBuilder keyBuilder = new StringBuilder();
        int keySize = 0;
        while (!(target.peek() == -1 || mode == JPathMode.SOLIDUS && target.peek() == 47 || mode == JPathMode.PERIOD && target.peek() == 46 || target.peek() == 91 || mode == JPathMode.PATH && target.peek() == 39)) {
            if (target.peek() == 92) {
                target.read();
                keyBuilder.append((char)target.read());
                ++keySize;
                continue;
            }
            keyBuilder.append((char)target.read());
            ++keySize;
        }
        return new KeyComponent(keyBuilder.toString(), keySize);
    }

    public PredicateComponent readPredicate(JPathReader target, JPathMode mode) throws ParserException {
        if (target.peek() == -1) {
            return null;
        }
        if (target.peek() != 91) {
            throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('['), Character.valueOf((char)target.peek())});
        }
        target.read();
        if (target.peek() == 42) {
            target.read();
            if (target.peek() == 93) {
                target.read();
            }
            return new AllPredicate();
        }
        if (ConstantUtility.isNumeric(target.peek())) {
            StringBuilder predicateComponentBuilder = new StringBuilder();
            predicateComponentBuilder.append((char)target.read());
            while (ConstantUtility.isNumeric(target.peek())) {
                predicateComponentBuilder.append((char)target.read());
            }
            if (target.peek() == 93) {
                target.read();
                return new SimpleIndexPredicate(Integer.parseInt(predicateComponentBuilder.toString()));
            }
            if (target.peek() == 44) {
                UnionPredicate unionPredicate = new UnionPredicate();
                int index = -1;
                while (ConstantUtility.isNumeric(target.peek()) || target.peek() == 44) {
                    if (target.peek() == 44) {
                        index = Integer.parseInt(predicateComponentBuilder.toString());
                        unionPredicate.addIndex(index);
                        target.read();
                        predicateComponentBuilder = new StringBuilder();
                        continue;
                    }
                    if (!ConstantUtility.isNumeric(target.peek())) continue;
                    predicateComponentBuilder.append((char)target.read());
                }
                if (target.peek() == 93) {
                    index = Integer.parseInt(predicateComponentBuilder.toString());
                    unionPredicate.addIndex(index);
                    target.read();
                    return unionPredicate;
                }
                throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
            }
            if (target.peek() == 58) {
                int start = Integer.parseInt(predicateComponentBuilder.toString());
                return this.readStartEndStepPredicate(target, predicateComponentBuilder, start);
            }
            throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
        }
        if (target.peek() == 36) {
            target.read();
            if (target.peek() == 93) {
                target.read();
                return LastIndexPredicate.LAST;
            }
            if (target.peek() == 45) {
                target.read();
                if (ConstantUtility.isDigit(target.peek())) {
                    StringBuilder predicateComponentBuilder = new StringBuilder();
                    predicateComponentBuilder.append((char)target.read());
                    while (ConstantUtility.isDigit(target.peek())) {
                        predicateComponentBuilder.append((char)target.read());
                    }
                    if (target.peek() == 93) {
                        target.read();
                        return new LastIndexPredicate(Integer.parseInt(predicateComponentBuilder.toString()));
                    }
                    throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
                }
                throw new UnsupportedOperationException("Not a digit in LastIndex.");
            }
            throw new JPathParserException("invalidValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
        }
        if (target.peek() == "last()".charAt(0)) {
            for (int i = 0; i < "last()".length(); ++i) {
                if (target.peek() != "last()".charAt(i)) {
                    throw new JPathParserException("invalidValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{"last()", Character.valueOf((char)target.peek())});
                }
                target.read();
            }
            if (target.peek() == 93) {
                target.read();
                return LastIndexPredicate.LAST;
            }
            if (target.peek() == 45) {
                target.read();
                if (ConstantUtility.isDigit(target.peek())) {
                    StringBuilder predicateComponentBuilder = new StringBuilder();
                    predicateComponentBuilder.append((char)target.read());
                    while (ConstantUtility.isDigit(target.peek())) {
                        predicateComponentBuilder.append((char)target.read());
                    }
                    if (target.peek() == 93) {
                        target.read();
                        return new LastIndexPredicate(Integer.parseInt(predicateComponentBuilder.toString()));
                    }
                    throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
                }
                throw new UnsupportedOperationException("Not a digit in LastIndex.");
            }
            throw new JPathParserException("invalidPathExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
        }
        if (target.peek() == 58) {
            int start = 0;
            StringBuilder predicateComponentBuilder = new StringBuilder();
            return this.readStartEndStepPredicate(target, predicateComponentBuilder, start);
        }
        if (target.peek() == 40) {
            return this.readExpressionPredicate(target, mode);
        }
        if (target.peek() == 63) {
            return this.readFilterPredicate(target, mode);
        }
        throw new UnsupportedOperationException("Invalid Predicate.");
    }

    public StartEndStepPredicate readStartEndStepPredicate(JPathReader target, StringBuilder predicateComponentBuilder, int start) throws ParserException {
        int end = -1;
        boolean step = true;
        StartEndStepPredicate startEndStepPredicate = new StartEndStepPredicate();
        if (target.peek() == 93) {
            int num = Integer.parseInt(predicateComponentBuilder.toString());
            target.read();
            return startEndStepPredicate;
        }
        throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
    }

    public ExpressionPredicate readExpressionPredicate(JPathReader target, JPathMode mode) throws ParserException {
        ExpressionPredicate expressionPredicate = new ExpressionPredicate();
        if (target.peek() == 40) {
            target.read();
            StringBuilder expressionStringBuilder = new StringBuilder();
            while (target.peek() != 41) {
                char c;
                if (target.peek() == -1) {
                    throw new JPathParserException("invalidPathFoundEndExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(')'), Character.valueOf((char)target.peek())});
                }
                target.skipWhitepace(expressionStringBuilder);
                ExpressionPredicate.ExpressionPredicateCombineOperator op = null;
                if (target.peek() == 38) {
                    while (target.peek() == 38) {
                        expressionStringBuilder.append((char)target.read());
                    }
                    op = ExpressionPredicate.ExpressionPredicateCombineOperator.AND;
                } else if (target.peek() == 124) {
                    while (target.peek() == 124) {
                        expressionStringBuilder.append((char)target.read());
                    }
                    op = ExpressionPredicate.ExpressionPredicateCombineOperator.OR;
                }
                target.skipWhitepace(expressionStringBuilder);
                if (target.peek() == 64) {
                    expressionStringBuilder.append((char)target.read());
                    if (target.peek() != 46) continue;
                    expressionStringBuilder.append((char)target.read());
                    target.skipWhitepace(expressionStringBuilder);
                    String attribute = null;
                    String value = null;
                    StringBuilder predicateComponentBuilder = new StringBuilder();
                    while (target.peek() != 41 && target.peek() != 60 && target.peek() != 62 && target.peek() != 45 && target.peek() != 61) {
                        c = (char)target.read();
                        expressionStringBuilder.append(c);
                        predicateComponentBuilder.append(c);
                    }
                    attribute = predicateComponentBuilder.toString().trim();
                    ExpressionPredicate.ExpressionPredicateOperator expressionPredicateOperator = null;
                    if (target.peek() == 41) {
                        expressionStringBuilder.append((char)target.read());
                        expressionPredicateOperator = ExpressionPredicate.ExpressionPredicateOperator.NOT_NULL;
                    } else if (target.peek() == 61) {
                        expressionStringBuilder.append((char)target.read());
                        expressionPredicateOperator = ExpressionPredicate.ExpressionPredicateOperator.EQUAL;
                    } else if (target.peek() == 60) {
                        expressionStringBuilder.append((char)target.read());
                        if (target.peek() == 61) {
                            expressionStringBuilder.append((char)target.read());
                            expressionPredicateOperator = ExpressionPredicate.ExpressionPredicateOperator.LESS_EQUAL;
                        } else {
                            expressionPredicateOperator = ExpressionPredicate.ExpressionPredicateOperator.LESS;
                        }
                    } else if (target.peek() == 62) {
                        expressionStringBuilder.append((char)target.read());
                        if (target.peek() == 61) {
                            expressionStringBuilder.append((char)target.read());
                            expressionPredicateOperator = ExpressionPredicate.ExpressionPredicateOperator.GREATER_EQUAL;
                        } else {
                            expressionPredicateOperator = ExpressionPredicate.ExpressionPredicateOperator.GREATER;
                        }
                    } else if (target.peek() == 45) {
                        expressionPredicateOperator = ExpressionPredicate.ExpressionPredicateOperator.MINUS;
                    }
                    target.skipWhitepace(expressionStringBuilder);
                    predicateComponentBuilder = new StringBuilder();
                    while (target.peek() != 41 && target.peek() != 38 && target.peek() != 124) {
                        if (target.peek() == -1) {
                            throw new JPathParserException("invalidPathFoundEndExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(')'), Character.valueOf((char)target.peek())});
                        }
                        c = (char)target.read();
                        expressionStringBuilder.append(c);
                        predicateComponentBuilder.append(c);
                    }
                    value = predicateComponentBuilder.toString().trim();
                    JSONParser jsonParser = new JSONParser(value);
                    Value jsonValue = jsonParser.parseValue();
                    target.skipWhitepace(expressionStringBuilder);
                    ExpressionPredicate.OperatorExpressionPredicateCondition predicateCondition = new ExpressionPredicate.OperatorExpressionPredicateCondition(attribute, expressionPredicateOperator, jsonValue);
                    if (op != null) {
                        predicateCondition.setCombine(op);
                        op = null;
                    }
                    expressionPredicate.conditions().add(predicateCondition);
                    continue;
                }
                if (this.jPathFunctionParseCheck(target.peek())) {
                    StringBuilder functionNameBuilder = new StringBuilder();
                    while (target.peek() != -1 && target.peek() != 40) {
                        c = (char)target.read();
                        expressionStringBuilder.append(c);
                        functionNameBuilder.append(c);
                    }
                    c = (char)target.read();
                    expressionStringBuilder.append(c);
                    target.skipWhitepace(expressionStringBuilder);
                    StringBuilder argumentsBuilder = new StringBuilder();
                    while (target.peek() != -1 && target.peek() != 41) {
                        c = (char)target.read();
                        expressionStringBuilder.append(c);
                        argumentsBuilder.append(c);
                    }
                    c = (char)target.read();
                    expressionStringBuilder.append(c);
                    FunctionArgument[] argumentArray = FunctionArgument.parseStringToArguments(argumentsBuilder.toString().trim());
                    ExpressionPredicate.FunctionExpressionPredicateCondition predicateCondition = new ExpressionPredicate.FunctionExpressionPredicateCondition(functionNameBuilder.toString(), argumentArray);
                    expressionPredicate.conditions().add(predicateCondition);
                    continue;
                }
                throw new JPathParserException("expression1", 0, target.getPositionNumber(), new Object[]{expressionStringBuilder.toString()});
            }
            target.read();
            expressionPredicate.setExpression(expressionStringBuilder.toString());
            if (target.peek() == 93) {
                expressionStringBuilder.append((char)target.read());
            }
            return expressionPredicate;
        }
        throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('('), Character.valueOf((char)target.peek())});
    }

    public ExpressionPredicate readFilterPredicate(JPathReader target, JPathMode mode) throws ParserException {
        if (target.peek() == 63) {
            target.read();
            if (target.peek() == 40) {
                ExpressionPredicate expression = this.readExpressionPredicate(target, mode);
                return expression;
            }
            throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('('), Character.valueOf((char)target.peek())});
        }
        throw new JPathParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('?'), Character.valueOf((char)target.peek())});
    }

    public boolean jPathFunctionParseCheck(int i) {
        return i == 114;
    }

    public static enum JPathMode {
        SOLIDUS,
        PERIOD,
        PATH;

    }
}

