/*
 * Decompiled with CFR 0.152.
 */
package jsonij.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jsonij.io.BitWiseUtils;
import jsonij.io.FormatUtils;

public class BufferUtils {
    public static final ByteBuffer createBuffer(int capacity) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(capacity);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    public static final String bufferToString(ByteBuffer buffer, int rowCount, boolean showValue) {
        int i;
        buffer.rewind();
        StringBuilder byteLineBuilder = new StringBuilder();
        StringBuilder characterLineBuilder = new StringBuilder();
        int line = 0;
        for (i = 0; i <= buffer.limit() - rowCount; i += rowCount) {
            byteLineBuilder.append(FormatUtils.leftPadString("" + line * rowCount, 4)).append(" | ");
            characterLineBuilder.setLength(0);
            for (int j = 0; j < rowCount; ++j) {
                byte c = buffer.get();
                byteLineBuilder.append(BitWiseUtils.convertToHexString(c)).append(' ');
                characterLineBuilder.append(c > 32 && c < 126 ? Character.valueOf((char)c) : " ").append(' ');
            }
            if (showValue) {
                byteLineBuilder.append(" |  ").append(characterLineBuilder.toString()).append(" |").append('\n');
            } else {
                byteLineBuilder.append('\n');
            }
            ++line;
        }
        characterLineBuilder.setLength(0);
        if (buffer.limit() % rowCount != 0) {
            byteLineBuilder.append(FormatUtils.leftPadString("" + line * rowCount, 4)).append(" | ");
            for (i = 0; i < buffer.limit() % rowCount; ++i) {
                byte c = buffer.get();
                byteLineBuilder.append(BitWiseUtils.convertToHexString(c)).append(' ');
                characterLineBuilder.append((char)c).append(' ');
            }
            if (showValue) {
                byteLineBuilder.append(" |  ").append(characterLineBuilder.toString()).append(" |").append('\n');
            } else {
                byteLineBuilder.append('\n');
            }
        }
        return byteLineBuilder.toString();
    }
}

