/*
 * Decompiled with CFR 0.152.
 */
package jsonij;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import jsonij.BSON;
import jsonij.JSON;
import jsonij.UBJSON;
import jsonij.Value;
import jsonij.ValueType;

public class StringImp
extends Value
implements Serializable,
CharSequence {
    private static final long serialVersionUID = -9098386245749540342L;
    public final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    protected String value;

    public StringImp(String orig) {
        this.value = orig == null ? "" : orig;
    }

    @Override
    public ValueType internalType() {
        return ValueType.STRING;
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof CharSequence || o instanceof JSON.String) {
            return o.toString().equals(this.value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public int nestedSize() {
        return 0;
    }

    @Override
    public String toJSON() {
        StringBuilder outputStringBuilder = new StringBuilder();
        outputStringBuilder.append('\"');
        block10: for (int i = 0; i < this.value.length(); ++i) {
            char c = this.value.charAt(i);
            switch (c) {
                case '\"': {
                    outputStringBuilder.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    outputStringBuilder.append("\\\\");
                    continue block10;
                }
                case '/': {
                    outputStringBuilder.append("\\/");
                    continue block10;
                }
                case '\b': {
                    outputStringBuilder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    outputStringBuilder.append("\\f");
                    continue block10;
                }
                case '\n': {
                    outputStringBuilder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    outputStringBuilder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    outputStringBuilder.append("\\t");
                    continue block10;
                }
                default: {
                    char a = c;
                    if (a == ' ' || a == '!' || a >= '#' && a <= '[' || a >= ']' && a <= '\u007f') {
                        outputStringBuilder.append(c);
                        continue block10;
                    }
                    String hex = Integer.toHexString(a);
                    outputStringBuilder.append("\\u");
                    for (int j = hex.length(); j < 4; ++j) {
                        outputStringBuilder.append("0");
                    }
                    outputStringBuilder.append(hex);
                }
            }
        }
        outputStringBuilder.append('\"');
        return outputStringBuilder.toString();
    }

    @Override
    public ByteBuffer toBSON(ByteBuffer buffer) {
        BSON.CODEC.encodeUTF8String(buffer, this.value);
        return buffer;
    }

    @Override
    public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
        UBJSON.CODEC.encodeString(buffer, this.value);
        return buffer;
    }
}

