/*
 * Decompiled with CFR 0.152.
 */
package jsonij;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jsonij.BSON;
import jsonij.Value;
import jsonij.ValueType;

public class ObjectImp<CS extends CharSequence, V extends Value>
extends Value
implements Map<CS, V> {
    private static final long serialVersionUID = 7601285884315492844L;
    public Map<CS, V> mapValue = new LinkedHashMap<CS, V>();

    @Override
    public ValueType internalType() {
        return ValueType.OBJECT;
    }

    @Override
    public void clear() {
        this.mapValue.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mapValue.containsKey((CharSequence)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mapValue.containsValue((Value)value);
    }

    @Override
    public Set<Map.Entry<CS, V>> entrySet() {
        return this.mapValue.entrySet();
    }

    public V get(int i) {
        Set<CS> keySet = this.mapValue.keySet();
        if (i < keySet.size()) {
            Iterator<CS> iterator = keySet.iterator();
            for (int j = 0; j < i - 1; ++j) {
                iterator.next();
            }
            return (V)((Value)this.mapValue.get((CharSequence)iterator.next()));
        }
        return null;
    }

    @Override
    public V get(Object key) {
        return (V)((Value)this.mapValue.get(key.toString()));
    }

    public V safeGet(Object key) {
        return (V)((Value)this.mapValue.get(key.toString()));
    }

    @Override
    public boolean isEmpty() {
        return this.mapValue.isEmpty();
    }

    @Override
    public Set<CS> keySet() {
        return this.mapValue.keySet();
    }

    @Override
    public V put(CS key, V value) {
        String keySequence = key.toString();
        return (V)((Value)this.mapValue.put(keySequence, value));
    }

    @Override
    public void putAll(Map<? extends CS, ? extends V> m) {
        this.mapValue.putAll(m);
    }

    @Override
    public V remove(Object key) {
        String keySequence = key.toString();
        return (V)((Value)this.mapValue.remove(keySequence));
    }

    @Override
    public int size() {
        return this.mapValue.size();
    }

    @Override
    public Collection<V> values() {
        return this.mapValue.values();
    }

    @Override
    public int nestedSize() {
        int c = 0;
        for (Value v : this.values()) {
            c += v.nestedSize();
        }
        return this.size() + c;
    }

    @Override
    public String toJSON() {
        Iterator<CS> keyIterator = this.mapValue.keySet().iterator();
        if (keyIterator.hasNext()) {
            StringBuilder json = new StringBuilder();
            json.append('{');
            CharSequence k = (CharSequence)keyIterator.next();
            Value v = this.get(k);
            json.append('\"').append(k.toString()).append('\"').append(':').append(v.toJSON());
            while (keyIterator.hasNext()) {
                k = (CharSequence)keyIterator.next();
                v = this.get(k);
                json.append(',').append('\"').append(k.toString()).append('\"').append(':').append(v.toJSON());
            }
            json.append('}');
            return json.toString();
        }
        return "{}";
    }

    @Override
    public ByteBuffer toBSON(ByteBuffer buffer) {
        int startPosition = buffer.position();
        buffer.putInt(0);
        Iterator<CS> keyIterator = this.mapValue.keySet().iterator();
        if (keyIterator.hasNext()) {
            while (keyIterator.hasNext()) {
                CharSequence k = (CharSequence)keyIterator.next();
                Value v = this.get(k);
                ValueType type = v.getValueType();
                buffer.put(type.getBSONType());
                BSON.CODEC.encodeCString(buffer, k.toString());
                v.toBSON(buffer);
            }
        }
        buffer.put((byte)0);
        int finishPosition = buffer.position();
        int size = finishPosition - startPosition;
        buffer.putInt(startPosition, size);
        buffer.position(finishPosition);
        buffer.flip();
        return buffer;
    }

    @Override
    public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

