/*
 * Decompiled with CFR 0.152.
 */
package jsonij;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import jsonij.BSON;
import jsonij.BSONTimestamp;
import jsonij.ObjectIdentifier;

public class BSONCodec {
    public static Charset CHARSET = Charset.forName("UTF-8");
    public final byte[] BYTE_ARRAY_4 = new byte[4];
    public final byte[] BYTE_ARRAY_8 = new byte[8];

    public boolean validateBufferOrder(ByteBuffer byteBuffer) {
        return byteBuffer.order() == ByteOrder.LITTLE_ENDIAN;
    }

    public double decodeDouble(ByteBuffer byteBuffer) {
        double d = byteBuffer.getDouble();
        return d;
    }

    public ByteBuffer encodeDouble(ByteBuffer byteBuffer, double value) {
        byteBuffer.putDouble(value);
        return byteBuffer;
    }

    public ByteBuffer encodeObjectID(ByteBuffer byteBuffer, ObjectIdentifier objectID) {
        byteBuffer.put(objectID.getContents());
        return byteBuffer;
    }

    public ObjectIdentifier decodeObjectID(byte[] byteBuffer) {
        return new ObjectIdentifier(byteBuffer);
    }

    public ByteBuffer encodeBSONBoolean(ByteBuffer byteBuffer, boolean value) {
        if (value) {
            byteBuffer.put((byte)1);
        } else {
            byteBuffer.put((byte)0);
        }
        return byteBuffer;
    }

    public boolean decodeBSONBoolean(ByteBuffer byteBuffer) {
        byte b = byteBuffer.get();
        if (b == 0) {
            return false;
        }
        return b == 1;
    }

    public long decodeUTCDateTime(ByteBuffer byteBuffer) {
        byte[] byteArray = this.BYTE_ARRAY_8;
        byteBuffer.get(byteArray);
        long dateValue = (long)byteArray[7] << 56 | (long)(byteArray[6] & 0xFF) << 48 | (long)(byteArray[5] & 0xFF) << 40 | (long)(byteArray[4] & 0xFF) << 32 | (long)(byteArray[3] & 0xFF) << 24 | (long)(byteArray[2] & 0xFF) << 16 | (long)(byteArray[1] & 0xFF) << 8 | (long)(byteArray[0] & 0xFF);
        return dateValue;
    }

    public ByteBuffer encodeUTCDateTime(ByteBuffer byteBuffer, long time) {
        byte[] byteArray = this.BYTE_ARRAY_8;
        byteArray[7] = (byte)(time >> 56);
        byteArray[6] = (byte)(time >> 48);
        byteArray[5] = (byte)(time >> 40);
        byteArray[4] = (byte)(time >> 32);
        byteArray[3] = (byte)(time >> 24);
        byteArray[2] = (byte)(time >> 16);
        byteArray[1] = (byte)(time >> 8);
        byteArray[0] = (byte)time;
        byteBuffer.put(byteArray);
        return byteBuffer;
    }

    public final int decodeInt32(ByteBuffer byteBuffer) {
        byte[] byteArray = this.BYTE_ARRAY_4;
        byteBuffer.get(byteArray);
        int int32 = byteArray[3] << 24 | (byteArray[2] & 0xFF) << 16 | (byteArray[1] & 0xFF) << 8 | byteArray[0] & 0xFF;
        return int32;
    }

    public final ByteBuffer encodeInt32(ByteBuffer byteBuffer, int value) {
        byte[] byteArray = this.BYTE_ARRAY_4;
        byteArray[3] = (byte)(value >> 24);
        byteArray[2] = (byte)(value >> 16);
        byteArray[1] = (byte)(value >> 8);
        byteArray[0] = (byte)value;
        byteBuffer.put(byteArray);
        return byteBuffer;
    }

    public BSONTimestamp decodeTimestamp(ByteBuffer byteBuffer) {
        byte[] byteArray = this.BYTE_ARRAY_4;
        byteBuffer.get(byteArray);
        int inc = byteArray[3] << 24 | (byteArray[2] & 0xFF) << 16 | (byteArray[1] & 0xFF) << 8 | byteArray[0] & 0xFF;
        byteBuffer.get(byteArray);
        int time = byteArray[3] << 24 | (byteArray[2] & 0xFF) << 16 | (byteArray[1] & 0xFF) << 8 | byteArray[0] & 0xFF;
        return new BSONTimestamp(time, inc);
    }

    public ByteBuffer encodeTimestamp(ByteBuffer byteBuffer, BSONTimestamp timestamp) {
        byte[] byteArray = this.BYTE_ARRAY_4;
        int inc = timestamp.getIncrement();
        byteArray[3] = (byte)(inc >> 24);
        byteArray[2] = (byte)(inc >> 16);
        byteArray[1] = (byte)(inc >> 8);
        byteArray[0] = (byte)inc;
        byteBuffer.put(byteArray);
        int time = timestamp.getTime();
        byteArray[3] = (byte)(time >> 24);
        byteArray[2] = (byte)(time >> 16);
        byteArray[1] = (byte)(time >> 8);
        byteArray[0] = (byte)time;
        byteBuffer.put(byteArray);
        return byteBuffer;
    }

    public long decodeInt64(ByteBuffer byteBuffer) {
        byte[] byteArray = this.BYTE_ARRAY_8;
        byteBuffer.get(byteArray);
        long int64 = (long)byteArray[7] << 56 | (long)(byteArray[6] & 0xFF) << 48 | (long)(byteArray[5] & 0xFF) << 40 | (long)(byteArray[4] & 0xFF) << 32 | (long)(byteArray[3] & 0xFF) << 24 | (long)(byteArray[2] & 0xFF) << 16 | (long)(byteArray[1] & 0xFF) << 8 | (long)(byteArray[0] & 0xFF);
        return int64;
    }

    public ByteBuffer encodeInt64(ByteBuffer byteBuffer, long int64) {
        byte[] byteArray = this.BYTE_ARRAY_8;
        byteArray[7] = (byte)(int64 >> 56);
        byteArray[6] = (byte)(int64 >> 48);
        byteArray[5] = (byte)(int64 >> 40);
        byteArray[4] = (byte)(int64 >> 32);
        byteArray[3] = (byte)(int64 >> 24);
        byteArray[2] = (byte)(int64 >> 16);
        byteArray[1] = (byte)(int64 >> 8);
        byteArray[0] = (byte)int64;
        byteBuffer.put(byteArray);
        return byteBuffer;
    }

    public ByteBuffer encodeUTF8String(ByteBuffer byteBuffer, String value) {
        byteBuffer.putInt(value.length() + 1);
        byteBuffer.put(value.getBytes(CHARSET));
        byteBuffer.put((byte)0);
        return byteBuffer;
    }

    public String decodeUTF8String(ByteBuffer byteBuffer) {
        int size = byteBuffer.getInt();
        byte[] stringBytes = new byte[size - 1];
        byteBuffer.get(stringBytes, 0, size - 1);
        String stringValue = new String(stringBytes, CHARSET);
        byteBuffer.get();
        return stringValue;
    }

    public ByteBuffer encodeCString(ByteBuffer byteBuffer, String value) {
        if (value == null || value.equals("")) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put(value.getBytes(CHARSET));
            byteBuffer.put((byte)0);
        }
        return byteBuffer;
    }

    public String decodeCString(ByteBuffer byteBuffer) {
        byte b;
        byteBuffer.mark();
        int c = 0;
        while ((b = byteBuffer.get()) != 0) {
            ++c;
        }
        byte[] elementBytes = new byte[c];
        byteBuffer.reset();
        byteBuffer.get(elementBytes, 0, c);
        byteBuffer.get();
        String element = new String(elementBytes, CHARSET);
        return element;
    }

    public ByteBuffer encodeDecimal128(ByteBuffer buffer, BSON.Decimal decimal) {
        int i;
        byte[] bytes = new byte[15];
        long low = decimal.decimal128.getLow();
        long high = decimal.decimal128.getLow();
        long mask = 255L;
        for (i = 14; i >= 7; --i) {
            bytes[i] = (byte)((low & mask) >>> (14 - i << 3));
            mask <<= 8;
        }
        mask = 255L;
        for (i = 6; i >= 1; --i) {
            bytes[i] = (byte)((high & mask) >>> (6 - i << 3));
            mask <<= 8;
        }
        mask = 0x1000000000000L;
        bytes[0] = (byte)((high & mask) >>> 48);
        return buffer.put(bytes);
    }

    public BSON.Decimal decodeDecimal128(ByteBuffer buffer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ByteBuffer encodeBinaryData(ByteBuffer buffer, BSON.BinaryData binaryData) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BSON.BinaryData decodeBinaryData(ByteBuffer buffer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String byteBufferToHexString(ByteBuffer byteBuffer) {
        StringBuilder builder = new StringBuilder();
        byteBuffer.rewind();
        if (byteBuffer.position() < byteBuffer.limit()) {
            byte value;
            while (byteBuffer.position() < byteBuffer.limit() - 1) {
                value = byteBuffer.get();
                builder.append(String.format("%02x", value)).append(' ');
            }
            value = byteBuffer.get();
            builder.append(String.format("%02x", value));
        }
        return builder.toString();
    }

    public String byteArrayToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        if (bytes.length > 0) {
            for (int i = 0; i < bytes.length - 1; ++i) {
                builder.append(String.format("%02x", bytes[i])).append(' ');
            }
            builder.append(String.format("%02x", bytes[bytes.length - 1]));
        }
        return builder.toString();
    }
}

