/*
 * Decompiled with CFR 0.152.
 */
package jsonij.parser;

import java.io.Reader;
import jsonij.parser.JSONReader;
import jsonij.parser.ParserException;
import jsonij.parser.Position;

public abstract class BaseJSONReader
implements JSONReader {
    protected int peekValue = -1;
    protected boolean hasPeeked = false;
    protected Position position = new Position();

    public BaseJSONReader() {
        this(null);
    }

    public BaseJSONReader(Reader reader) {
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    protected Position setPosition(Position position) {
        this.position = position;
        return this.position;
    }

    @Override
    public boolean isHasPeeked() {
        return this.hasPeeked();
    }

    @Override
    public boolean hasPeeked() {
        return this.hasPeeked;
    }

    @Override
    public void setHasPeeked(boolean hasPeeked) {
        this.hasPeeked = hasPeeked;
    }

    @Override
    public int getLineNumber() {
        return this.getPosition().getLineNumber();
    }

    @Override
    public int getPositionNumber() {
        return this.getPosition().getPostionNumber();
    }

    @Override
    public int peek() throws ParserException {
        if (!this.hasPeeked) {
            this.peekValue = this.readNext();
            this.hasPeeked = true;
        }
        return this.peekValue;
    }

    @Override
    public int read() throws ParserException {
        if (this.hasPeeked) {
            this.hasPeeked = false;
            return this.peekValue;
        }
        return this.readNext();
    }

    protected abstract int readNext() throws ParserException;

    @Override
    public void close() {
    }

    protected void handleNewLine() throws ParserException {
        this.getPosition().newLine();
    }

    public String toString() {
        String state;
        try {
            state = String.format("Next Char %s", Character.valueOf((char)this.peek()));
        }
        catch (ParserException e) {
            state = String.format("Unknown State: %s", e.toString());
        }
        return String.format("Reader %s: %s", this.getPosition(), state);
    }

    @Override
    public abstract JSONReader getStringReader(JSONReader.Mode var1);
}

